<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $productId = isset($data['productId']) ? intval($data['productId']) : 0;
    $preferred = isset($data['preferred']) ? intval($data['preferred']) : null;

    if ($productId > 0 && ($preferred === 0 || $preferred === 1)) {
        $stmt = $conn->prepare("UPDATE tdu_products SET preferred = ? WHERE productid = ?");
        $stmt->bind_param('ii', $preferred, $productId);

        if ($stmt->execute()) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Failed to update preferred status']);
        }

        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid input data']);
    }

    $conn->close();
}
?>
