<?php
// ajax_qbo_manual_match.php
// MODIFIED: Now logs changes to the history table.

ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

// --- Essential Includes ---
require_once __DIR__ . '/qbo_functions.php';
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/dbconn.php';
global $conn;

// MODIFIED: Include the new helper file
require_once __DIR__ . '/qbo_reconciliation_helpers.php';

$response = ['success' => false, 'error' => 'Invalid request.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
$rec_id = $_POST['reconciliation_id'] ?? null;
$item_index = $_POST['item_index'] ?? null;
$selected_bill_id = $_POST['bill_id'] ?? null;
$selected_line_id = $_POST['line_id'] ?? null;

if ($rec_id && isset($item_index) && $selected_bill_id && $selected_line_id) {
$qboUtil = null;
try {
// 1. Initialize QBO Utility to fetch the full bill object
$qboBaseConfigFile = __DIR__ . '/config/qbo_config.php';
$qboTokenStorageFile = __DIR__ . '/tokens/qbo_token.json';

function loadQBOTokens() {
$qboTokenStorageFile = __DIR__ . '/tokens/qbo_token.json';
if (!file_exists($qboTokenStorageFile)) return null;
$json = file_get_contents($qboTokenStorageFile);
return $json ? json_decode($json, true) : null;
}

if (file_exists($qboBaseConfigFile)) { require $qboBaseConfigFile; } else { throw new Exception("QBO base config not found."); }
$currentTokens = loadQBOTokens();
if ($currentTokens && isset($qboBaseConfig)) {
$qboConfigForLibrary = array_merge($qboBaseConfig, ['accessTokenKey' => $currentTokens['access_token'], 'refreshTokenKey' => $currentTokens['refresh_token']]);
$qboUtil = new QBOUtilityLibrary($qboConfigForLibrary);
} else {
throw new Exception("Could not initialize QBO connection.");
}

// 2. Fetch the full Bill object from QBO using the selected ID
$fullBillObject = $qboUtil->getDataService()->FindById('Bill', $selected_bill_id);
if (!$fullBillObject) {
throw new Exception("Could not find Bill with ID {$selected_bill_id} in QBO.");
}

$matched_line_amount = 'N/A';
if (!empty($fullBillObject->Line)) {
$lines = is_array($fullBillObject->Line) ? $fullBillObject->Line : [$fullBillObject->Line];
foreach ($lines as $line) {
if ($line->Id == $selected_line_id) {
$matched_line_amount = $line->Amount ?? 'N/A';
break;
}
}
}

// 3. Update the database
mysqli_query($conn, "START TRANSACTION");
$stmt_get = mysqli_prepare($conn, "SELECT qbo_bills_json FROM tdu_qbo_reconciliation WHERE id = ? FOR UPDATE");
mysqli_stmt_bind_param($stmt_get, "i", $rec_id);
mysqli_stmt_execute($stmt_get);
$result = mysqli_stmt_get_result($stmt_get);
$row = mysqli_fetch_assoc($result);
mysqli_stmt_close($stmt_get);

if ($row) {
$qbo_bills_data = json_decode($row['qbo_bills_json'], false);

if (isset($qbo_bills_data[$item_index])) {

// MODIFIED: Capture the 'before' state
$detailsBefore = ['status' => 'needs_review', 'potential_matches' => $qbo_bills_data[$item_index]->potential_matches ?? []];

// Create the new "matched" object
$newMatchData = (object)[
'status' => 'matched',
'bill_object' => $fullBillObject,
'matched_line_id' => $selected_line_id,
'matched_line_amount' => $matched_line_amount,
'match_method' => 'Manual'
];
$qbo_bills_data[$item_index] = $newMatchData;

// MODIFIED: Capture the 'after' state
$detailsAfter = [
'status' => 'matched',
'bill_id' => $selected_bill_id,
'line_id' => $selected_line_id,
'amount' => $matched_line_amount,
'doc_number' => $fullBillObject->DocNumber ?? 'N/A'
];

$new_json = json_encode($qbo_bills_data);
$stmt_update = mysqli_prepare($conn, "UPDATE tdu_qbo_reconciliation SET qbo_bills_json = ? WHERE id = ?");
mysqli_stmt_bind_param($stmt_update, "si", $new_json, $rec_id);

if(mysqli_stmt_execute($stmt_update)){
// MODIFIED: Log the change AFTER the main update is successful
log_reconciliation_change($conn, (int)$rec_id, (int)$item_index, 'Manual Match', $detailsBefore, $detailsAfter);
$response['success'] = true;
$response['error'] = null;
} else {
throw new Exception("Failed to update reconciliation record in database.");
}
mysqli_stmt_close($stmt_update);

} else {
$response['error'] = "Item index {$item_index} not found in stored data.";
}
} else {
$response['error'] = "Reconciliation record with ID {$rec_id} not found.";
}
mysqli_query($conn, "COMMIT");

} catch (Exception $e) {
mysqli_query($conn, "ROLLBACK");
$response['error'] = "An error occurred: " . $e->getMessage();
}
}
}

echo json_encode($response);