<?php
include 'dbconn.php';
include 'dictionaries.php';
include 'html_utility.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quoteid = isset($_POST['quoteid']) ? $_POST['quoteid'] : '';
    $productid = isset($_POST['productid']) ? $_POST['productid'] : '';
    $day = isset($_POST['day']) ? $_POST['day'] : '';
    $insert_sequence = isset($_POST['insert_sequence']) ? (int) $_POST['insert_sequence'] : 0;

    $sql = "SELECT quote_no, adults, children, infants, child_ages FROM vtiger_quotes WHERE quoteid='$quoteid';";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $quote_number = $row['quote_no'];
        $adults_no = (int) $row['adults'];
        $children_no = (int) $row['children'];
        $infants_no = (int) $row['infants'];
        $child_ages_array = [];
        if($row['child_ages'] != '') {
            $child_ages_array = array_map('intval', explode(',', $row['child_ages']));
        }
        $total_passengers = (int) $adults_no + (int) $children_no;
        $total_children = $children_no + $infants_no;
    }

    $sql = "SELECT associated FROM tdu_products_associated WHERE productid='$productid'";
    $result = mysqli_query($conn, $sql);

    $associatedArray = [$productid];
    if ($result && mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $associatedArray[] = $row['associated'];
        }
    }

    if($insert_sequence > 0) {
        $associatedArraysize = count($associatedArray);
        $sql = "UPDATE vtiger_display_order 
                SET display_order = display_order + $associatedArraysize
                WHERE id='$quoteid' AND display_order > $insert_sequence";
        mysqli_query($conn, $sql);
    }

    if ($productid && $day) {
        foreach ($associatedArray as $productid) {
            $sql = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid='$quoteid';";
            $result = mysqli_query($conn, $sql);
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $cf_1162 = $row['cf_1162']; // yyyy-mm-dd format

                $date = new DateTime($cf_1162);
                $date->modify('+' . ((int) $day - 1) . ' days');
                $activity_date = $date->format('Y-m-d');
            }
            
            $sql = "SELECT MAX(sequence_no) AS max_sequence_no FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
            $result = mysqli_query($conn, $sql);
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $sequence_no = ($row['max_sequence_no'] !== NULL) ? $row['max_sequence_no'] : 0;
            } else {
                echo "Error: " . mysqli_error($conn);
            }

            $cars_required = 1;
            
            $productid = (int) $productid;
            // $cfByProductID = getCFByProductID($conn);
            // $cf_928 = isset($cfByProductID[$productid]) ? $cfByProductID[$productid] : NULL;
            
            $sql = "SELECT unitPrice, childPrice, infantPrice, familyPrice, sharingPrice, 
                            vendorid, category, seats, childOnly, childOnlyAgeMin, childOnlyAgeMax 
                    FROM tdu_products WHERE productid='$productid';";
            $result = mysqli_query($conn, $sql);
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                $vendorid = $row['vendorid'];
                $cf_928 = $row['category'];

                $childOnlyCount = 0;
                if($row['childOnly'] == 1) {
                    if ($child_ages_array == []) {
                        continue;
                    }
                    $childOnlyAgeMin = (int) $row['childOnlyAgeMin'];
                    $childOnlyAgeMax = (int) $row['childOnlyAgeMax'];

                    $childOnlyCount = count(array_filter($child_ages_array, function ($age) use ($childOnlyAgeMin, $childOnlyAgeMax) {
                        return $age >= $childOnlyAgeMin && $age <= $childOnlyAgeMax;
                    }));

                    if($childOnlyCount == 0) {
                        continue;
                    }
                }
                $rowChildOnly = $row['childOnly'];
                
                $row_dynamic = fetchDynamicPrice($conn, $productid, $activity_date);
                if($row['category'] == 'Hotel') {
                    $price = (float) $row_dynamic['sharingPrice'];
                } else {
                    $price = (float) $row_dynamic['unitPrice'];
                }
                $child_price = (float) $row_dynamic['childPrice'];
                $infant_price = (float) $row_dynamic['infantPrice'];

                $surcharge = getSurchargeForDate($conn, $productid, $activity_date);
                $price += $surcharge;
                $child_price += $surcharge;

                $families = 0;
                if(substr($quote_number, -1) != 'G' && $adults_no >= 2 && $children_no >= 2) {
                    $family_price = floatval($row['familyPrice']);
                    if ($family_price > 0) {
                        $families = min(floor($adults_no / 2), floor($children_no / 2));
                        $remaining_adults = $adults_no - ($families * 2);
                        $remaining_children = $children_no - ($families * 2);
                
                        $total_price_family = ($families * $family_price) + ($remaining_adults * $price) + ($remaining_children * $child_price);
                        $total_price_family = ceil($total_price_family / ($adults_no + $children_no));

                        $price = $total_price_family;
                        $child_price = $total_price_family;
                    }
                }
                $transfers_seats = $row['seats'] ? (int) $row['seats'] : 0;
            }

            // Insert into vtiger_inventoryproductrel
            $sequence_no++;
            if($cf_928 == 'Transfers' && $transfers_seats > 0) {
                $cars_required = ceil($total_passengers / $transfers_seats);

                $insert_sql1 = "INSERT INTO vtiger_inventoryproductrel (id, day, productid, vendorid, cf_928, sequence_no, quantity) 
                                VALUES ('$quoteid', '$day', '$productid', '$vendorid', '$cf_928', '$sequence_no', '$cars_required')";
                $query = "INSERT INTO vtiger_coach_info (quoteid, sequence_no, coach_number, seaters_number, price) 
                            VALUES ($quoteid, $sequence_no, $cars_required, $transfers_seats, $price)";
                mysqli_query($conn, $query) or die(mysqli_error($conn));
                $price = $price * $cars_required;
            } else {
                $insert_sql1 = "INSERT INTO vtiger_inventoryproductrel (id, day, productid, vendorid, cf_928, sequence_no, families) 
                                VALUES ('$quoteid', '$day', '$productid', '$vendorid', '$cf_928', '$sequence_no', '$families')";
            }
            mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));

            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'adults', '$adults_no', NOW(), '$username_ajax')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'children', '$children_no', NOW(), '$username_ajax')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                        VALUES ('$quoteid', '$sequence_no', 'infants', '$infants_no', NOW(), '$username_ajax')";
            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

            if($insert_sequence > 0) {
                $insert_sequence++;

                $insert_sql1 = "INSERT INTO vtiger_display_order (id, sequence_no, display_order) 
                                VALUES ('$quoteid', '$sequence_no', '$insert_sequence')";
                mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
            } else {
                // Step 1: Get the current max display_order for the given quoteid
                $query = "SELECT COALESCE(MAX(display_order), 0) + 1 AS new_display_order 
                        FROM vtiger_display_order 
                        WHERE id = '$quoteid'";
                $result = mysqli_query($conn, $query);

                if ($result) {
                    $row = mysqli_fetch_assoc($result);
                    $new_display_order = $row['new_display_order'];

                    // Step 2: Insert the new record with the calculated display_order
                    $insert_sql1 = "INSERT INTO vtiger_display_order (id, sequence_no, display_order) 
                                VALUES ('$quoteid', '$sequence_no', '$new_display_order')";

                    mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
                } 
            }

            if($cf_928 == 'Transfers') {
                if($rowChildOnly == 1 && $childOnlyCount > 0) {
                    $price *= $childOnlyCount;
                }
                $existing_subquoteid_query = "SELECT DISTINCT subquoteid, pax_min, pax_max FROM vtiger_products_saleprice WHERE quoteid = '$quoteid' AND cf_928 = '$cf_928';";
                $existing_subquoteid_result = mysqli_query($conn, $existing_subquoteid_query);

                $existing_subquoteids = [];
                $pax_values = [];

                while ($row = mysqli_fetch_assoc($existing_subquoteid_result)) {
                    $existing_subquoteids[] = $row['subquoteid'];
                    $pax_values[$row['subquoteid']] = [
                        'pax_min' => $row['pax_min'],
                        'pax_max' => $row['pax_max']
                    ];
                }

                if(mysqli_num_rows($existing_subquoteid_result) > 0) {
                    foreach ($existing_subquoteids as $subquoteid) {
                        // Get the pax_min and pax_max for the current subquoteid
                        $pax_min = $pax_values[$subquoteid]['pax_min'];
                        $pax_max = $pax_values[$subquoteid]['pax_max'];
                        
                        $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, pax_min, pax_max) 
                                        VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', '$subquoteid', '$price', '$pax_min', '$pax_max')
                                        ON DUPLICATE KEY UPDATE sale_price = '$price', pax_min = VALUES(pax_min), pax_max = VALUES(pax_max), updated_at = NOW()";
                        mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                    }
                }

                else {
                    $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price) 
                                    VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 0, '$price')
                                    ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                    mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                }
            }
            else {
                $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, sale_price_child, sale_price_infant)  
                                VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 1, '$price', '$child_price', '$infant_price')
                                ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
            }
        }
        echo json_encode(['status' => 'success', 'message' => 'Product Added successfully.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid product ID.']);
    }

} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
