<?php
include 'dbconn.php';
include 'dictionaries.php';
include 'html_utility.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $quoteid = isset($_POST['quoteid']) ? $_POST['quoteid'] : '';
    $templateid = isset($_POST['templateid']) ? $_POST['templateid'] : '';
    if($quoteid == '' || $templateid == '') {
        echo "Error: Both quoteid and templateid must be provided.";
        exit;
    }
    $sql = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid='$quoteid';";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $dateOfTravel = $row['cf_1162'];
        $dateOfTravel = new DateTime($dateOfTravel);
    }

    if (!empty($templateid) && !empty($dateOfTravel)) {
        // Get the template info
        $sql = "SELECT start_month, end_month, replace_templateid FROM tdu_templates WHERE templateid = $templateid";
        $result = $conn->query($sql);
    
        if ($result && $result->num_rows > 0) {
            $templateData = $result->fetch_assoc();
            $startMonth = (int) $templateData['start_month'];
            $endMonth = (int) $templateData['end_month'];
            $replaceTemplateId = (int) $templateData['replace_templateid'];
    
            // Proceed only if template has a limited date range
            if ($startMonth > 0 || $endMonth > 0) {
                $travelMonth = (int) $dateOfTravel->format('n'); // 1 (Jan) to 12 (Dec)
    
                // Handle normal and wrapping-around range like Nov-Feb
                $inRange = ($startMonth <= $endMonth)
                    ? ($travelMonth >= $startMonth && $travelMonth <= $endMonth)
                    : ($travelMonth >= $startMonth || $travelMonth <= $endMonth);
    
                if (!$inRange && $replaceTemplateId > 0) {
                    $templateid = $replaceTemplateId;
                }
            }
        }
    }

    $sql = "SELECT MAX(day) AS max_day FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
    $result = mysqli_query($conn, $sql);
    if ($result) {
        $row = mysqli_fetch_assoc($result);
        $max_day = ($row['max_day'] !== NULL) ? (int) $row['max_day'] : 0;
        if($max_day > 1) {
            $max_day -= 1;
        }
    } else {
        $max_day = 0;
    }
    $dateOfTravel->modify("+$max_day days");

    $sql = "SELECT * FROM tdu_templates WHERE templateid='$templateid';";
    $result_cities = mysqli_query($conn, $sql);
    if ($result_cities) {
        $row = mysqli_fetch_assoc($result_cities);

        $cities_string = $row['city'];
        $cities_array = explode(',', $cities_string);
        $city_dates = [];

        $checkin_date = $dateOfTravel;

        foreach ($cities_array as $city_info) {
            list($city, $days) = explode(':', $city_info);
            $days = (int) $days;
        
            // Compute check-in and check-out dates
            $current_checkin = clone $checkin_date;
            $current_checkout = clone $checkin_date;
            $current_checkout->modify("+$days days");
        
            // Store in an associative array
            $city_dates[$city] = [
                'checkin' => $current_checkin->format('Y-m-d'),
                'checkout' => $current_checkout->format('Y-m-d'),
                'nights' => $days
            ];
        
            // Move check-in date forward for the next city
            $checkin_date = $current_checkout;
        }
    } else {
        $city_dates = [];
    }

    $sql = "SELECT * FROM tdu_template_products WHERE templateid='$templateid' ORDER BY sequence_no ASC;";
    $result_parent = mysqli_query($conn, $sql);

    if ($result_parent) {
        $sequence_no = 1;
        $sub_sequence_no = 1;
        while ($row = mysqli_fetch_assoc($result_parent)) {
            $productid = $row['productid'];
            $event_time = $row['event_time'];
            $event_day = $row['day'];
            $show_status = $row['show_status'];

            if($productid == 0) {
                if($row['event_name'] == '') {
                    continue;
                } else {
                    $event_name = mysqli_real_escape_string($conn, $row['event_name']);
                    $insertsql = "INSERT INTO vtiger_itinerary_new_event (quoteid, sequence_no, day, tour_time, event_name, sub_sequence_no) 
                                  VALUES ('$quoteid', '$sequence_no', '$event_day', '$event_time', '$event_name', '$sub_sequence_no')";
                    if (!mysqli_query($conn, $insertsql)) {
                        echo "Error: ". mysqli_error($conn);
                    }
                    $sub_sequence_no++;
                    continue;
                }
            } else {
                $sub_sequence_no = 1;
            }

            $sqlc = "SELECT city, category FROM tdu_products WHERE productid='$productid';";
            $resultc = mysqli_query($conn, $sqlc);
            $category = '';
            if ($resultc) {
                $rowc = mysqli_fetch_assoc($resultc);
                $category = $rowc['category'];
                $city = $rowc['city'];
            }
            if($category == '') {
                continue;
            }

            if ($category == 'Hotel') {
                $productid = $row['productid'];
                $checkin = 1;
                $nights = 1;
        
                if ($productid && $checkin && $nights) {
                    $checkout = $checkin + $nights - 1;
        
                    for ($day = $checkin; $day <= $checkout; $day++) {
                        $sql = "SELECT MAX(sequence_no) AS max_sequence_no FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
                        $result = mysqli_query($conn, $sql);
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            $sequence_no = ($row['max_sequence_no'] !== NULL) ? $row['max_sequence_no'] : 0;
                        } else {
                            echo "Error: " . mysqli_error($conn);
                        }
        
                        $sql = "SELECT quote_no, adults, children, infants, nsingle_room, ndouble_room, ntriple_room, nchild_without_bed FROM vtiger_quotes WHERE quoteid='$quoteid';";
                        $result = mysqli_query($conn, $sql);
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            $quote_number = $row['quote_no'];
                            $adults_no = $row['adults'];
                            $children_no = $row['children'];
                            $infants_no = $row['infants'];
                            $nsingle_room = $row['nsingle_room'];
                            $ndouble_room = $row['ndouble_room'];
                            $ntriple_room = $row['ntriple_room'];
                            $nchild_without_bed = $row['nchild_without_bed'];
                        }
                        
                        $productid = (int) $productid;
                        // $cfByProductID = getCFByProductID($conn);
                        // $cf_928 = isset($cfByProductID[$productid]) ? $cfByProductID[$productid] : NULL;
                        
                        $sql = "SELECT unitPrice, childPrice, sharingPrice, category, vendorid FROM tdu_products WHERE productid='$productid';";
                        $result = mysqli_query($conn, $sql);
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            $vendorid = $row['vendorid'];
                            $cf_928 = $row['category'];
                            if($row['category'] == 'Hotel') {
                                $price = (float) $row['sharingPrice'];
                            } else {
                                $price = $row['unitPrice'];
                            }
                            $child_price = $row['childPrice'];
                        }
        
                        // Insert into vtiger_inventoryproductrel
                        $sequence_no++;
                        $insert_sql1 = "INSERT INTO vtiger_inventoryproductrel (id, day, productid, vendorid, cf_928, sequence_no) 
                                        VALUES ('$quoteid', '$day', '$productid', '$vendorid', '$cf_928', '$sequence_no')";
                        mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
        
                        // Insert no of paxes
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'adults', '$adults_no', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'children', '$children_no', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'infants', '$infants_no', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
        
                        // Insert rooms
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'single_rooms', '$nsingle_room', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'double_rooms', '$ndouble_room', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'triple_rooms', '$ntriple_room', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'child_without_bed', '$nchild_without_bed', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));

                        if(isset($city_dates[$city])) {
                            $hotel_checkin = $city_dates[trim($city)]['checkin'];
                            $hotel_checkout = $city_dates[trim($city)]['checkout'];

                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                            VALUES ('$quoteid', '$sequence_no', 'check_in', '$hotel_checkin', NOW(), '$username_ajax')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                            VALUES ('$quoteid', '$sequence_no', 'check_out', '$hotel_checkout', NOW(), '$username_ajax')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
        
                        // Step 1: Get the current max display_order for the given quoteid
                        $query = "SELECT COALESCE(MAX(display_order), 0) + 1 AS new_display_order 
                                FROM vtiger_display_order 
                                WHERE id = '$quoteid'";
                        $result = mysqli_query($conn, $query);
        
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            if(true) {
                                $new_display_order = $row['new_display_order'];
                            }
        
                            // Step 2: Insert the new record with the calculated display_order
                            $insert_sql1 = "INSERT INTO vtiger_display_order (id, sequence_no, display_order) 
                                        VALUES ('$quoteid', '$sequence_no', '$new_display_order')";
        
                            mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
                        } 
        
                        if($cf_928 == 'Transfers') {
                            $existing_subquoteid_query = "SELECT DISTINCT subquoteid, pax_min, pax_max FROM vtiger_products_saleprice WHERE quoteid = '$quoteid' AND cf_928 = '$cf_928';";
                            $existing_subquoteid_result = mysqli_query($conn, $existing_subquoteid_query);
        
                            $existing_subquoteids = [];
                            $pax_values = [];
        
                            while ($row = mysqli_fetch_assoc($existing_subquoteid_result)) {
                                $existing_subquoteids[] = $row['subquoteid'];
                                $pax_values[$row['subquoteid']] = [
                                    'pax_min' => $row['pax_min'],
                                    'pax_max' => $row['pax_max']
                                ];
                            }
        
                            if(mysqli_num_rows($existing_subquoteid_result) > 0) {
                                foreach ($existing_subquoteids as $subquoteid) {
                                    // Get the pax_min and pax_max for the current subquoteid
                                    $pax_min = $pax_values[$subquoteid]['pax_min'];
                                    $pax_max = $pax_values[$subquoteid]['pax_max'];
                                    
                                    $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, pax_min, pax_max) 
                                                    VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', '$subquoteid', '$price', '$pax_min', '$pax_max')
                                                    ON DUPLICATE KEY UPDATE sale_price = '$price', pax_min = VALUES(pax_min), pax_max = VALUES(pax_max), updated_at = NOW()";
                                    mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                                }
                            }
        
                            else {
                                $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price) 
                                                VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 0, '$price')
                                                ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                                mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                            }
                        }
                        else if($cf_928 == 'Hotel') {
                            $nights = $city_dates[trim($city)]['nights'];
                            $triple_tmp = $price + 60;
                            $child_tmp = ceil(($price + 60) / 3);
                            $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, sale_price_single, sale_price_double, sale_price_triple, sale_price_child_with_bed, sale_price_child_no_bed, nights)  
                                            VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 1, '0', '$price', '$price', '$triple_tmp', '$child_tmp', '0', '$nights')
                                            ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                            mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                        }
                        else {
                            $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, sale_price_child)  
                                            VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 1, '$price', '$child_price')
                                            ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                            mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                        }
                    }
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'Start Date missing']);
                }
            } else {
                $productid = $row['productid'];
                $day = (int) $row['day'] + $max_day;

                $sql = "SELECT quote_no, adults, children, infants, child_ages FROM vtiger_quotes WHERE quoteid='$quoteid';";
                $result = mysqli_query($conn, $sql);
                if ($result) {
                    $row = mysqli_fetch_assoc($result);
                    $quote_number = $row['quote_no'];
                    $adults_no = (int) $row['adults'];
                    $children_no = (int) $row['children'];
                    $infants_no = (int) $row['infants'];
                    $child_ages_array = [];
                    if($row['child_ages'] != '') {
                        $child_ages_array = array_map('intval', explode(',', $row['child_ages']));
                    }
                    $total_passengers = (int) $adults_no + (int) $children_no;
                    $total_children = $children_no + $infants_no;
                }
        
                $sql = "SELECT a.associated 
                        FROM tdu_products_associated a
                        LEFT JOIN tdu_products p ON a.associated=p.productid
                        WHERE a.productid='$productid' AND p.childOnly='1';";
                $result = mysqli_query($conn, $sql);
        
                $associatedArray = [$productid];
                if ($result && mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        $associatedArray[] = $row['associated'];
                    }
                }
        
                if ($productid && $day) {
                    foreach ($associatedArray as $productid) {
                        $sql = "SELECT cf_1162 FROM vtiger_quotescf WHERE quoteid='$quoteid';";
                        $result = mysqli_query($conn, $sql);
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            $cf_1162 = $row['cf_1162']; // yyyy-mm-dd format

                            $date = new DateTime($cf_1162);
                            $date->modify('+' . ((int) $day - 1) . ' days');
                            $activity_date = $date->format('Y-m-d');
                        }
                        
                        $sql = "SELECT MAX(sequence_no) AS max_sequence_no FROM vtiger_inventoryproductrel WHERE id='$quoteid';";
                        $result = mysqli_query($conn, $sql);
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            $sequence_no = ($row['max_sequence_no'] !== NULL) ? $row['max_sequence_no'] : 0;
                        } else {
                            echo "Error: " . mysqli_error($conn);
                        }
        
                        $cars_required = 1;
                        
                        $productid = (int) $productid;
                        // $cfByProductID = getCFByProductID($conn);
                        // $cf_928 = isset($cfByProductID[$productid]) ? $cfByProductID[$productid] : NULL;
                        
                        $sql = "SELECT unitPrice, childPrice, infantPrice, familyPrice, sharingPrice, 
                                        vendorid, category, seats, childOnly, childOnlyAgeMin, childOnlyAgeMax 
                                FROM tdu_products WHERE productid='$productid';";
                        $result = mysqli_query($conn, $sql);
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            $vendorid = $row['vendorid'];
                            $cf_928 = $row['category'];

                            $childOnlyCount = 0;
                            if($row['childOnly'] == 1) {
                                if ($child_ages_array == []) {
                                    continue;
                                }
                                $childOnlyAgeMin = (int) $row['childOnlyAgeMin'];
                                $childOnlyAgeMax = (int) $row['childOnlyAgeMax'];

                                $childOnlyCount = count(array_filter($child_ages_array, function ($age) use ($childOnlyAgeMin, $childOnlyAgeMax) {
                                    return $age >= $childOnlyAgeMin && $age <= $childOnlyAgeMax;
                                }));

                                if($childOnlyCount == 0) {
                                    continue;
                                }
                            }
                            $rowChildOnly = $row['childOnly'];
                            
                            $row_dynamic = fetchDynamicPrice($conn, $productid, $activity_date);
                            if($row['category'] == 'Hotel') {
                                $price = (float) $row_dynamic['sharingPrice'];
                            } else {
                                $price = (float) $row_dynamic['unitPrice'];
                            }
                            $child_price = (float) $row_dynamic['childPrice'];
                            $infant_price = (float) $row_dynamic['infantPrice'];

                            $surcharge = getSurchargeForDate($conn, $productid, $activity_date);
                            $price += $surcharge;
                            $child_price += $surcharge;

                            $families = 0;
                            if(substr($quote_number, -1) != 'G' && $adults_no >= 2 && $children_no >= 2) {
                                $family_price = floatval($row['familyPrice']);
                                if ($family_price > 0) {
                                    $families = min(floor($adults_no / 2), floor($children_no / 2));
                                    $remaining_adults = $adults_no - ($families * 2);
                                    $remaining_children = $children_no - ($families * 2);
                            
                                    $total_price_family = ($families * $family_price) + ($remaining_adults * $price) + ($remaining_children * $child_price);
                                    $total_price_family = ceil($total_price_family / ($adults_no + $children_no));
        
                                    $price = $total_price_family;
                                    $child_price = $total_price_family;
                                }
                            }
                            $transfers_seats = $row['seats'] ? (int) $row['seats'] : 0;
                        }
        
                        // Insert into vtiger_inventoryproductrel
                        $sequence_no++;
                        if($cf_928 == 'Transfers' && $transfers_seats > 0) {
                            $cars_required = ceil($total_passengers / $transfers_seats);
        
                            $insert_sql1 = "INSERT INTO vtiger_inventoryproductrel (id, day, productid, vendorid, cf_928, sequence_no, quantity, tourtime, show_in_so) 
                                            VALUES ('$quoteid', '$day', '$productid', '$vendorid', '$cf_928', '$sequence_no', '$cars_required', '$event_time', '$show_status')";
                            $query = "INSERT INTO vtiger_coach_info (quoteid, sequence_no, coach_number, seaters_number, price) 
                                        VALUES ($quoteid, $sequence_no, $cars_required, $transfers_seats, $price)";
                            mysqli_query($conn, $query) or die(mysqli_error($conn));
                            $price = $price * $cars_required;
                        } else {
                            $insert_sql1 = "INSERT INTO vtiger_inventoryproductrel (id, day, productid, vendorid, cf_928, sequence_no, families, tourtime, show_in_so) 
                                            VALUES ('$quoteid', '$day', '$productid', '$vendorid', '$cf_928', '$sequence_no', '$families', '$event_time', '$show_status')";
                        }
                        mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
        
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'adults', '$adults_no', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'children', '$children_no', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                    VALUES ('$quoteid', '$sequence_no', 'infants', '$infants_no', NOW(), '$username_ajax')";
                        mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        if($cf_928 != 'Transfers') {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'tourtime', '$event_time', NOW(), '$username_ajax')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        } else {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 0, 'tourtime', '$event_time', NOW(), '$username_ajax')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
        
                        // Step 1: Get the current max display_order for the given quoteid
                        $query = "SELECT COALESCE(MAX(display_order), 0) + 1 AS new_display_order 
                                FROM vtiger_display_order 
                                WHERE id = '$quoteid'";
                        $result = mysqli_query($conn, $query);
        
                        if ($result) {
                            $row = mysqli_fetch_assoc($result);
                            $new_display_order = $row['new_display_order'];
        
                            // Step 2: Insert the new record with the calculated display_order
                            $insert_sql1 = "INSERT INTO vtiger_display_order (id, sequence_no, display_order) 
                                        VALUES ('$quoteid', '$sequence_no', '$new_display_order')";
        
                            mysqli_query($conn, $insert_sql1) or die(mysqli_error($conn));
                        } 
        
                        if($cf_928 == 'Transfers') {
                            if($rowChildOnly == 1 && $childOnlyCount > 0) {
                                $price *= $childOnlyCount;
                            }
                            $existing_subquoteid_query = "SELECT DISTINCT subquoteid, pax_min, pax_max FROM vtiger_products_saleprice WHERE quoteid = '$quoteid' AND cf_928 = '$cf_928';";
                            $existing_subquoteid_result = mysqli_query($conn, $existing_subquoteid_query);
        
                            $existing_subquoteids = [];
                            $pax_values = [];
        
                            while ($row = mysqli_fetch_assoc($existing_subquoteid_result)) {
                                $existing_subquoteids[] = $row['subquoteid'];
                                $pax_values[$row['subquoteid']] = [
                                    'pax_min' => $row['pax_min'],
                                    'pax_max' => $row['pax_max']
                                ];
                            }
        
                            if(mysqli_num_rows($existing_subquoteid_result) > 0) {
                                foreach ($existing_subquoteids as $subquoteid) {
                                    // Get the pax_min and pax_max for the current subquoteid
                                    $pax_min = $pax_values[$subquoteid]['pax_min'];
                                    $pax_max = $pax_values[$subquoteid]['pax_max'];
                                    
                                    $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, pax_min, pax_max) 
                                                    VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', '$subquoteid', '$price', '$pax_min', '$pax_max')
                                                    ON DUPLICATE KEY UPDATE sale_price = '$price', pax_min = VALUES(pax_min), pax_max = VALUES(pax_max), updated_at = NOW()";
                                    mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                                }
                            }
        
                            else {
                                $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price) 
                                                VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 0, '$price')
                                                ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                                mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                            }
                        }
                        else {
                            $insert_sql2 = "INSERT INTO vtiger_products_saleprice (quoteid, productid, sequence_no, cf_928, subquoteid, sale_price, sale_price_child, sale_price_infant)  
                                            VALUES ('$quoteid', '$productid', '$sequence_no', '$cf_928', 1, '$price', '$child_price', '$infant_price')
                                            ON DUPLICATE KEY UPDATE sale_price='$price', updated_at=NOW()";
                            mysqli_query($conn, $insert_sql2) or die(mysqli_error($conn));
                        }
                    }
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'Invalid product ID.']);
                }
            }
        }
    }

    $update_sql = "UPDATE tdu_templates SET used = used + 1 WHERE templateid='$templateid'";
    mysqli_query($conn, $update_sql);
    
    $response = [
        'success' => true,
        'new_quote_no' => $quote_number,
    ];
    echo json_encode($response);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
