<?php
session_start();
include 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $auto_id = (int) $_POST['auto_id'];

    $sql = "SELECT * FROM vtiger_invoice_adjustment_revert WHERE auto_id = $auto_id";
    $result = mysqli_query($conn, $sql);

    if (!$result || mysqli_num_rows($result) == 0) {
        echo json_encode(['success' => false, 'error' => 'Invalid auto_id']);
        exit;
    }

    $row = mysqli_fetch_assoc($result);
    $adjustment_type = $row['adjustment_type'];
    $quoteid = $row['quoteid'];
    $created_by = $row['created_by'];
    $revert_data = json_decode($row['revert_data'], true);

    switch ($adjustment_type) {
        case 'add_product':
            $unique_void_id = mysqli_real_escape_string($conn, $revert_data['unique_void_id']);
            $sql_del = "DELETE FROM vtiger_invoice_add_products WHERE auto_id = '$unique_void_id';";
            mysqli_query($conn, $sql_del);
            break;

        case 'adjust_product_price':
            $sequence_no = mysqli_real_escape_string($conn, $revert_data['product']);
            $adjustment_sign = $revert_data['adjustment_sign'];
            $adjustment_amount = (float) $revert_data['adjustment_amount'];
            $reverse_amount = ($adjustment_sign === '+') ? -$adjustment_amount : $adjustment_amount;

            $sql_revert = "UPDATE vtiger_products_saleprice 
                            SET 
                                sale_price = sale_price + $reverse_amount,
                                sale_price_child = sale_price_child + $reverse_amount,
                                price_adjust = CASE 
                                                    WHEN price_adjust + $reverse_amount = 0 THEN ''
                                                    ELSE price_adjust + $reverse_amount
                                                END
                            WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no'";
            mysqli_query($conn, $sql_revert);
            break;

        case 'adjust_overall_pax':
            $quoteid = mysqli_real_escape_string($conn, $revert_data['quoteid']);
            $adults = (int) mysqli_real_escape_string($conn, $revert_data['adults_amount']) * ($revert_data['adults_sign'] === '+' ? -1 : 1);
            $children = (int) mysqli_real_escape_string($conn, $revert_data['children_amount']) * ($revert_data['children_sign'] === '+' ? -1 : 1);
            $infants = (int) mysqli_real_escape_string($conn, $revert_data['infants_amount']) * ($revert_data['infants_sign'] === '+' ? -1 : 1);
            $single_room = (int) mysqli_real_escape_string($conn, $revert_data['single_room_amount']) * ($revert_data['single_room_sign'] === '+' ? -1 : 1);
            $double_room = (int) mysqli_real_escape_string($conn, $revert_data['double_room_amount']) * ($revert_data['double_room_sign'] === '+' ? -1 : 1);
            $triple_room = (int) mysqli_real_escape_string($conn, $revert_data['triple_room_amount']) * ($revert_data['triple_room_sign'] === '+' ? -1 : 1);
        
            $sql = "UPDATE vtiger_quotes 
                    SET adults = adults + $adults, 
                        children = children + $children, 
                        infants = infants + $infants, 
                        nsingle_room = nsingle_room + $single_room, 
                        ndouble_room = ndouble_room + $double_room, 
                        ntriple_room = ntriple_room + $triple_room 
                    WHERE quoteid = '$quoteid'";
        
            if (mysqli_query($conn, $sql)) {
                $sequence_sql = "SELECT sequence_no, cf_928 FROM vtiger_inventoryproductrel WHERE id = '$quoteid'";
                $sequence_result = mysqli_query($conn, $sequence_sql);

                // Loop through each sequence_no and process the meta values
                while ($row = mysqli_fetch_assoc($sequence_result)) {
                    $sequence_no = $row['sequence_no'];
                    $cf_928 = $row['cf_928'];

                    if($cf_928 != 'Transfers') {
                        $meta_keys = ['adults', 'children', 'infants'];
                        foreach ($meta_keys as $meta_key) {
                            $meta_sql = "SELECT meta_value 
                                        FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no' AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC LIMIT 1";
                            $meta_result = mysqli_query($conn, $meta_sql);
                            $latest_meta = mysqli_fetch_assoc($meta_result);
                            $latest_pax[$meta_key] = (int) ($latest_meta['meta_value'] ?? 0);
                        }
        
                        $new_adults = $latest_pax['adults'] + $adults;
                        $new_children = $latest_pax['children'] + $children;
                        $new_infants = $latest_pax['infants'] + $infants;

                        // Insert new meta values if there was a change
                        if ($adults != 0) {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'adults', '$new_adults', NOW(), 'Adjustment Revert')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
                        if ($children != 0) {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'children', '$new_children', NOW(), 'Adjustment Revert')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
                        if ($infants != 0) {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'infants', '$new_infants', NOW(), 'Adjustment Revert')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
                    }

                    if($cf_928 == 'Hotel') {
                        $meta_keys = ['single_rooms', 'double_rooms', 'triple_rooms'];
                        $latest_pax = [];
                        foreach ($meta_keys as $meta_key) {
                            $meta_sql = "SELECT meta_value 
                                        FROM vtiger_itinerary 
                                        WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no' AND meta_key = '$meta_key' 
                                        ORDER BY created_at DESC LIMIT 1";
                            $meta_result = mysqli_query($conn, $meta_sql);
                            $latest_meta = mysqli_fetch_assoc($meta_result);
                            $latest_pax[$meta_key] = (int) ($latest_meta['meta_value'] ?? 0);
                        }
                        $new_single_rooms = $latest_pax['single_rooms'] + $single_room;
                        $new_double_rooms = $latest_pax['double_rooms'] + $double_room;
                        $new_triple_rooms = $latest_pax['triple_rooms'] + $triple_room;
                
                        // Insert new meta values if there was a change
                        if ($single_room != 0) {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'single_rooms', '$new_single_rooms', NOW(), 'Adjustment Revert')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
                        if ($double_room != 0) {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'double_rooms', '$new_double_rooms', NOW(), 'Adjustment Revert')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
                        if ($triple_room != 0) {
                            $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                        VALUES ('$quoteid', '$sequence_no', 'triple_rooms', '$new_triple_rooms', NOW(), 'Adjustment Revert')";
                            mysqli_query($conn, $insert_sql) or die(mysqli_error($conn));
                        }
                    }
                }
            }
            break;

        case 'refund':
            $quoteid = mysqli_real_escape_string($conn, $revert_data['quoteid']);
            $sequence_no = mysqli_real_escape_string($conn, $revert_data['product']);
            $pax_deduction = (int) mysqli_real_escape_string($conn, $revert_data['pax_deduction']);

            $query = "SELECT meta_value FROM vtiger_itinerary WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' AND meta_key='adults' ORDER BY created_at DESC LIMIT 1";
            $result = mysqli_query($conn, $query);
            $row = mysqli_fetch_assoc($result);
            if ($row) {
                // Step 2: Apply deduction to meta_value
                $old_meta_value = (int) $row['meta_value'];
                $new_meta_value = $old_meta_value + $pax_deduction;

                // Step 3: Insert the new row with the updated meta_value
                $insert_query = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by)
                                VALUES ('$quoteid', '$sequence_no', 'adults', '$new_meta_value', NOW(), 'Adjustment Revert')";
                mysqli_query($conn, $insert_query);
            }

            $unique_void_id = mysqli_real_escape_string($conn, $revert_data['unique_void_id']);
            $sql_del = "DELETE FROM vtiger_invoice_refunds WHERE auto_id = '$unique_void_id';";
            mysqli_query($conn, $sql_del);
            break;

        default:
            echo json_encode(['success' => false, 'error' => 'Unknown adjustment type']);
            exit;
    }

    $sql_update = "UPDATE vtiger_invoice_adjustment_history SET voided = 1 WHERE auto_id = '$auto_id';";
    mysqli_query($conn, $sql_update);

    // Mark this revert as used (optional - or you can delete it)
    $sql_cleanup = "DELETE FROM vtiger_invoice_adjustment_revert WHERE auto_id = $auto_id";
    mysqli_query($conn, $sql_cleanup);

    echo json_encode(['success' => true]);
}
?>
