<?php
if (!isset($_POST['productCode'], $_POST['startDate'])) {
    echo json_encode(['success' => false, 'message' => 'Missing parameters.']);
    exit;
}

$productCode = $_POST['productCode'];
$startDate = $_POST['startDate'];
$adults_no = $_POST['adultsNo'] ?? 1;

$startTimeLocal = "$startDate 00:00:00";
$endTime = new DateTime($startDate);
$endTimeLocal = $endTime->format('Y-m-d') . ' 23:59:59';

$apiKey = 'b5a46c6c39624b908c2aef115af33942';
$url = "https://api.rezdy.com/v1/availability?apiKey=" . urlencode($apiKey) . "&productCode=" . urlencode($productCode) . "&startTimeLocal=" . urlencode($startTimeLocal) . "&endTimeLocal=" . urlencode($endTimeLocal) . "&minAvailability=" . urlencode($adults_no);

// Use cURL to fetch data
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);

if ($response === false) {
    echo json_encode(['success' => false, 'message' => 'cURL error: ' . curl_error($ch)]);
    curl_close($ch);
    exit;
}

curl_close($ch);
$data = json_decode($response, true);
$options = [];

if (!empty($data['sessions'])) {
    foreach ($data['sessions'] as $session) {
        if (isset($session['startTimeLocal'])) {
            $time = date('H:i', strtotime($session['startTimeLocal']));
            $adultPrice = '';
            $childPrice = '';
            if (!empty($session['priceOptions'])) {
                foreach ($session['priceOptions'] as $priceOption) {
                    if ($priceOption['label'] === 'Adult') {
                        $adultPrice = $priceOption['price'];
                    }
                    if ($priceOption['label'] === 'Child') {
                        $childPrice = $priceOption['price'];
                    }
                }
            }
            $options[] = [
                'time' => $time,
                'adultPrice' => $adultPrice,
                'childPrice' => $childPrice
            ];
        }
    }
}

echo json_encode(['success' => true, 'options' => $options]);
?>
