<?php
header('Content-Type: application/json');

include "dbconn.php";
$apiKey = 'b5a46c6c39624b908c2aef115af33942';

if(!isset($_POST['quoteid']) || empty($_POST['quoteid'])) {
    echo json_encode(["message" => "Missing Quote Number"]);
    exit;
}

$bookingProductCategory = "";
if (isset($_POST['cardToken']) && !empty($_POST['cardToken'])) {
    $bookingProductCategory = "marketplace";
    $cardToken = htmlspecialchars($_POST['cardToken']);
    $creditCard = ["cardToken" => $cardToken];
} 
if (isset($_POST['paymentType']) && $_POST['paymentType'] == 'cash') {
    $bookingProductCategory = "negotiated";
}
if(empty($bookingProductCategory)) {
    echo json_encode(["message" => "Invalid Payment Type"]);
    exit;
}

$timeSelections = json_decode($_POST['timeSelections'], true);
if (empty($timeSelections) || !is_array($timeSelections)) {
    echo json_encode(["message" => "Invalid time selections"]);
    exit;
}

$firstName = '';
$lastName = '';
$phone = '';
$email = 'operations@turtledownunder.com.au';
$country = 'Australia';
$negotiatedTotal = 0;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $quoteid = htmlspecialchars($_POST['quoteid']);
    $specialRequirements = htmlspecialchars($_POST['specialRequirements'] ?? '');

    // quote details
    $sql = "SELECT vq.quote_no, vq.adults, vq.children, vqcf.cf_1162 AS travel_start_date FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
            WHERE vq.quoteid = '$quoteid'";
    $result = mysqli_query($conn, $sql);
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $quote_no = $row['quote_no'];
        $travel_start_date = $row['travel_start_date'];

        // Quantities
        $adults = $row['adults'];
        $children = $row['children'];
        $quantities = [];
        if (!empty($adults) && intval($adults) > 0) {
            $quantities[] = [
                "optionLabel" => "Adult",
                "value" => intval($adults)
            ];
        }
        if (!empty($children) && intval($children) > 0) {
            $quantities[] = [
                "optionLabel" => "Child",
                "value" => intval($children)
            ];
        }
        if ($quantities == []) {
            echo json_encode(["message" => "No quantities found for booking."]);
            exit;
        }
    } else {
        echo json_encode(["message" => "Error fetching quote details: " . mysqli_error($conn)]);
        exit;
    }

    // participants
    $participants = [];
    $pax_sql = "SELECT surname, given_name, phone FROM vtiger_pax_in_hotel WHERE quoteid = '$quoteid'";
    $pax_result = mysqli_query($conn, $pax_sql);
    if ($pax_result && mysqli_num_rows($pax_result) > 0) {
        while ($row = mysqli_fetch_assoc($pax_result)) {
            $participants[] = [
                "fields" => [
                    ["label" => "First Name", "value" => htmlspecialchars($row['given_name'])],
                    ["label" => "Last Name", "value" => htmlspecialchars($row['surname'])],
                ]
            ];
            if (empty($firstName) && empty($lastName)) {
                $firstName = htmlspecialchars($row['given_name']);
                $lastName = htmlspecialchars($row['surname']);
                $phone = htmlspecialchars($row['phone']);
            }
        }
    } else {
        echo json_encode(["message" => "Error fetching participants: " . mysqli_error($conn)]);
        exit;
    }

    // products booking
    $items = [];
    $bookedProducts = [];
    $sql_rezdy_booking = "SELECT vi.day, vi.sequence_no, tp.category, tp.productName, tp.rezdy_uni_code, tp.rezdy_uni_category 
                          FROM vtiger_inventoryproductrel vi
                          LEFT JOIN tdu_products tp ON vi.productid=tp.productid
                          WHERE vi.id = '$quoteid' AND tp.rezdy_uni_code IS NOT NULL AND tp.rezdy_uni_code != '' 
                            AND tp.rezdy_uni_category = '$bookingProductCategory'
                            AND booking_status = 'Pending';";
    $result_rezdy_booking = mysqli_query($conn, $sql_rezdy_booking);
    if ($result_rezdy_booking && mysqli_num_rows($result_rezdy_booking) > 0) {
        while ($row = mysqli_fetch_assoc($result_rezdy_booking)) {
            if (!isset($timeSelections[$row['sequence_no']]) || empty($timeSelections[$row['sequence_no']]['time'])) {
                continue;
            }
            $productCode = $row['rezdy_uni_code'];

            if($row['rezdy_uni_category'] == 'negotiated') {
                $negotiatedTotal += (float) $timeSelections[$row['sequence_no']]['adultPrice'] * (int) $adults + (float) $timeSelections[$row['sequence_no']]['childPrice'] * (int) $children;
            }

            // Construct startTimeLocal
            $day = (int) $row['day'] - 1;
            $startDate = new DateTime($travel_start_date);
            $startDate->modify("+" . $day . " days");
            $startTimeLocal = $startDate->format('Y-m-d') . ' ' . $timeSelections[$row['sequence_no']]['time'] . ':00';

            // Add item
            $items[] = [
                "productCode" => $productCode,
                "startTimeLocal" => $startTimeLocal,
                "quantities" => $quantities,
                "participants" => $participants
            ];
            $bookedProducts[] = [
                "sequence_no" => $row['sequence_no'],
                "category" => $row['category']
            ];
        }
    } else {
        echo json_encode(["message" => "Error fetching products: " . mysqli_error($conn)]);
        exit;
    }

    if ($bookedProducts == []) {
        echo json_encode(["message" => "No products found for booking."]);
        exit;
    }

    $bookingMessage = '';

    if(empty($firstName) && empty($lastName)) {
        echo json_encode(["message" => "Pax List is incomplete."]);
        exit;
    }
    
    $bookingData = [
        "resellerReference" => $quote_no,
        "customer" => [
            "firstName" => $firstName,
            "lastName" => $lastName,
            "email" => $email,
            "phone" => $phone
        ],
        "items" => $items,
        "fields" => [
            ["label" => "Special Requirements", "value" => $specialRequirements]
        ]
    ];

    if ($bookingProductCategory == "marketplace") {
        $bookingData["creditCard"] = $creditCard;
    } elseif ($bookingProductCategory == "negotiated") {
        $payments = [
            [
                "amount" => round($negotiatedTotal),
                "type" => "CASH",
                "label" => "Paid in cash to API specification demo company"
            ]
        ];
        $bookingData["payments"] = $payments;
    }

    $bookingResponse = createRezdyBooking($apiKey, $bookingData);
    if (isset($bookingResponse['requestStatus']['success']) && $bookingResponse['requestStatus']['success'] == true) {
        $bookingMessage .= "Booking sent";

        if (isset($bookingResponse['booking']['status']) && $bookingResponse['booking']['status'] == 'CONFIRMED') {
            $bookingMessage .= " and confirmed";
            $confirmationCode = $bookingResponse['booking']['orderNumber'];

            foreach ($bookedProducts as $product) {
                $sequence_no = $product['sequence_no'];
                $category = $product['category'];
                $tourtime = $timeSelections[$sequence_no]['time'];

                if($category != 'Transfers') {
                    $sql = "INSERT INTO vtiger_itinerary 
                            (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                            VALUES ('$quoteid', '$sequence_no', 'tourtime', '$tourtime', NOW(), 'Rezdy Automation')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                    $sql = "INSERT INTO vtiger_itinerary 
                            (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                            VALUES ('$quoteid', '$sequence_no', 'booking_status', 'Confirmation received', NOW(), 'Rezdy Automation')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                    $sql = "INSERT INTO vtiger_itinerary 
                            (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                            VALUES ('$quoteid', '$sequence_no', 'confirmation_number', '$confirmationCode', NOW(), 'Rezdy Automation')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                } else {
                    $sql = "INSERT INTO vtiger_itinerary 
                            (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                            VALUES ('$quoteid', '$sequence_no', '0', 'tourtime', '$tourtime', NOW(), 'Rezdy Automation')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                    $sql = "INSERT INTO vtiger_itinerary 
                            (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                            VALUES ('$quoteid', '$sequence_no', '0', 'booking_status', 'Confirmation received', NOW(), 'Rezdy Automation')";
                    mysqli_query($conn, $sql) or die(mysqli_error($conn));
                }

                $update_sql = "UPDATE vtiger_inventoryproductrel SET tourtime = '$tourtime' WHERE sequence_no = '$sequence_no' AND id = '$quoteid'";
                mysqli_query($conn, $update_sql) or die("Error updating booking status: " . mysqli_error($conn));
                $update_sql2 = "UPDATE vtiger_inventoryproductrel SET booking_status = 'Confirmation received' WHERE sequence_no = '$sequence_no' AND id = '$quoteid'";
                mysqli_query($conn, $update_sql2) or die("Error updating booking status: " . mysqli_error($conn));
            }
            $bookingResult = "confirmed";
        } else {
            $bookingResult = "requested";
        }
    } else {
        $bookingMessage .= "Booking failed: " . $bookingResponse['requestStatus']['error']['errorMessage'];
        if (isset($bookingResponse['requestStatus']['error']['validationErrors'])) {
            $bookingMessage .= " Validation Errors: " . json_encode($bookingResponse['requestStatus']['error']['validationErrors']);
        }
        $bookingResult = "failed";
    }
    
    echo json_encode(["message" => $bookingMessage]);

    $timestamp = date("Ymd-His");
    $filename = "rezdy_booking_log/{$bookingResult}-{$quote_no}-post-{$timestamp}.json";
    file_put_contents($filename, json_encode($bookingData, JSON_PRETTY_PRINT));
    $filename = "rezdy_booking_log/{$bookingResult}-{$quote_no}-res-{$timestamp}.json";
    file_put_contents($filename, json_encode($bookingResponse, JSON_PRETTY_PRINT));
}

function createRezdyBooking($apiKey, $bookingData) {
    $url = "https://api.rezdy.com/v1/bookings?apiKey=" . urlencode($apiKey);
    // $url = "https://api.rezdy-staging.com/v1/bookings?apiKey=" . urlencode($apiKey);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($bookingData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    if ($response === false) {
        return "Error: Curl request failed: " . curl_error($ch);
    }
    curl_close($ch);

    $data = json_decode($response, true);
    if ($data === null) {
        return "Error: Failed to decode JSON response";
    }
    return $data;
}
?>
