<?php
$apiKey = '81c3566e60ef42e6afa1c2719e7843fd';
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 20;
$offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;

$params = [
    'apiKey' => $apiKey,
    'limit' => $limit,
    'offset' => $offset
];

$params['orderStatus'] = 'CONFIRMED';
if (!empty($_GET['orderStatus'])) {
    $params['orderStatus'] = $_GET['orderStatus'];
}
if (!empty($_GET['search'])) {
    $params['search'] = $_GET['search'];
}
if (!empty($_GET['resellerReference'])) {
    $params['resellerReference'] = $_GET['resellerReference'];
}
if (!empty($_GET['minDateCreated'])) {
    $params['minDateCreated'] = $_GET['minDateCreated'] . 'T00:00:00Z';
}
if (!empty($_GET['maxDateCreated'])) {
    $params['maxDateCreated'] = $_GET['maxDateCreated'] . 'T23:59:59Z';
}

$query = http_build_query($params);
$url = "https://api.rezdy-staging.com/v1/bookings?$query";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);
$bookings = $data['bookings'] ?? [];

$results = [];

foreach ($bookings as $booking) {
    $resellerReference = $booking['resellerReference'] ?? '';
    $customer = $booking['customer'] ?? [];
    $customerName = trim(($customer['firstName'] ?? '') . ' ' . ($customer['lastName'] ?? ''));
    $customerPhone = $customer['phone'] ?? '';
    $amount = ($booking['totalCurrency'] ?? '') . ' ' . ($booking['totalAmount'] ?? '0');
    $created = (new DateTime($booking['dateCreated'], new DateTimeZone('UTC')))->setTimezone(new DateTimeZone('Australia/Melbourne'))->format('d/m/Y H:i');

    $productList = '';
    foreach ($booking['items'] as $item) {
        $startTimeLocal = isset($item['startTimeLocal']) ? DateTime::createFromFormat('Y-m-d H:i:s', $item['startTimeLocal'], new DateTimeZone('UTC')) : null;
        $startFormatted = $startTimeLocal ? $startTimeLocal->setTimezone(new DateTimeZone('Australia/Melbourne'))->format('d/m/Y H:i') : '';
        $productList .= ($startFormatted ? $startFormatted . ' ' : '') . htmlspecialchars($item['productName']) . ' (' . htmlspecialchars($item['productCode']) . ')<br>';
    }

    $results[] = [
        'orderNumber' => htmlspecialchars($booking['orderNumber']),
        'resellerReference' => htmlspecialchars($resellerReference),
        'status' => htmlspecialchars($booking['status']),
        'product' => $productList,
        'customer' => htmlspecialchars($customerName) . ($customerPhone ? '<br>' . htmlspecialchars($customerPhone) : ''),
        'amount' => htmlspecialchars($amount),
        'created' => htmlspecialchars($created),
        'source' => htmlspecialchars($booking['resellerSource'] ?? ''),
    ];
}

header('Content-Type: application/json');
echo json_encode($results);
?>
