<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $vendorId = $_POST['vendorid'] ?? '';
    $alias = $_POST['alias'] ?? '';

    if (!$vendorId || !$alias) {
        echo json_encode(['success' => false, 'message' => 'Missing data.']);
        exit;
    }

    // Fetch existing rezdy_uni_vendor value
    $stmt = $conn->prepare("SELECT rezdy_uni_vendor FROM tdu_vendors WHERE vendorid = ?");
    $stmt->bind_param("i", $vendorId);
    $stmt->execute();
    $stmt->bind_result($currentValue);
    $stmt->fetch();
    $stmt->close();

    // Parse current value
    $aliases = array_filter(array_map('trim', explode(';;', $currentValue)));
    
    // Add new alias if not already present
    if (!in_array($alias, $aliases)) {
        $aliases[] = $alias;
    }

    $newValue = implode(';;', $aliases);

    // Update with new value
    $updateStmt = $conn->prepare("UPDATE tdu_vendors SET rezdy_uni_vendor = ?, bookingMethod = 'Rezdy' WHERE vendorid = ?");
    $updateStmt->bind_param("si", $newValue, $vendorId);

    if ($updateStmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Vendor linked successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Update failed.']);
    }

    $updateStmt->close();
    $conn->close();
}
?>
