<?php
include 'rezdyconn.php';

$searchFilter = isset($_POST['search']) ? trim($_POST['search']) : '';
$orgId = isset($_POST['org_id']) ? (int)$_POST['org_id'] : 0;

$sql = "SELECT productCode, name, supplierName, city, countryCode, currency, advertisedPrice, rate FROM products WHERE 1=1";

if ($searchFilter !== '') {
    $escaped = $rezdyconn->real_escape_string($searchFilter);
    $sql .= " AND (productCode LIKE '%$escaped%' OR name LIKE '%$escaped%')";
} else {
    $sql .= " AND 0"; // no result by default
}

$sql .= " ORDER BY name ASC LIMIT 10";
$result = $rezdyconn->query($sql);
?>

<?php if ($result && $result->num_rows > 0): ?>
    <table class="styled-table" style="width=100%;">
        <tr>
            <th>Code</th>
            <th>Product</th>
            <th>Supplier</th>
            <th>City</th>
            <th>Country</th>
            <th>Price</th>
            <th>Type</th>
            <th></th>
        </tr>
        <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['productCode']) ?></td>
                <td><?= htmlspecialchars($row['name']) ?></td>
                <td><?= htmlspecialchars($row['supplierName']) ?></td>
                <td><?= htmlspecialchars($row['city']) ?></td>
                <td><?= htmlspecialchars(strtoupper($row['countryCode'])) ?></td>
                <td><?= htmlspecialchars($row['currency']) ?> <?= htmlspecialchars($row['advertisedPrice']) ?></td>
                <td><?= htmlspecialchars(strtoupper($row['rate'])) ?></td>
                <td>
                    <button class="select-rezdy-btn" data-code="<?= htmlspecialchars($row['productCode']) ?>" data-org="<?= $orgId ?>">
                        <i class="fa-solid fa-link"></i>
                    </button>
                </td>
            </tr>
        <?php endwhile; ?>
    </table>
<?php else: ?>
    <p style="text-align: center;">No products found.</p>
<?php endif; ?>
