<?php
include 'dbconn.php';
include 'rezdyconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $orgId = isset($_POST['org_id']) ? (int)$_POST['org_id'] : 0;
    $rezdyCode = isset($_POST['rezdy_code']) ? trim($_POST['rezdy_code']) : '';
    $rezdyCode = mysqli_real_escape_string($rezdyconn, $rezdyCode);

    $rezdysql = "SELECT rate FROM products WHERE productCode = '$rezdyCode';";
    $rezdyresult = mysqli_query($rezdyconn, $rezdysql);
    if ($rezdyresult && mysqli_num_rows($rezdyresult) > 0) {
        $rezdyrow = mysqli_fetch_assoc($rezdyresult);
        $rezdyRate = $rezdyrow['rate'] ?? 'negotiated';
    } else {
        $rezdyRate = 'negotiated';
    }

    if ($orgId <= 0) {
        echo "Invalid organization ID.";
        exit;
    }

    // Sanitize and prepare the update
    $stmt = $conn->prepare("UPDATE tdu_products SET rezdy_uni_code = ?, rezdy_uni_category = ? WHERE productid = ?");
    $stmt->bind_param("ssi", $rezdyCode, $rezdyRate, $orgId);

    if ($stmt->execute()) {
        echo "Rezdy code updated successfully.";
    } else {
        echo "Error updating Rezdy code: " . $conn->error;
    }

    $stmt->close();
} else {
    echo "Invalid request method.";
}
?>
