<?php
require 'dbconn.php';
require 'ai_email_functions.php';

header('Content-Type: application/json');

if (isset($_POST['conversation_id'])) {
    $conversation_id = $_POST['conversation_id'];

    $confirmation_ai_array = null;
    $invoice_ai_array = null;

    $result = AIUpdateQuoteByEmail($conversation_id, $conn);
    if ($result['status'] != 'success') {
        echo json_encode(['status' => 'error']);
        exit;
    }
    $confirmation_ai_array = $result['confirmation_ai_array'];
    $invoice_ai_array = $result['invoice_ai_array'];    

    echo json_encode([
        'status' => 'success',
        'confirmation_ai_array' => $confirmation_ai_array,
        'invoice_ai_array' => $invoice_ai_array
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Missing conversation_id']);
}


function AIUpdateQuoteByEmail($conversation_id, $conn, $email_inserted_sql_id = null) {
    $category_by_ai = classifyConversationPurpose($conversation_id, $conn);
    $invoice_ai_array = null;
    $confirmation_ai_array = null;

    if ($category_by_ai == 'invoice' || $category_by_ai == 'both') {
        $invoice_ai_array = processConversationForInvoice($conversation_id, $conn);
        if( $invoice_ai_array['invoiceVendorName'] != 'N/A' && $invoice_ai_array['matches'] == 'yes') {
            $invoiceVendorName = $invoice_ai_array['invoiceVendorName'];
            $quoteNumber = $invoice_ai_array['quoteNumber'];
            $invoiceTotal = $invoice_ai_array['invoiceTotal'];
            $saved_file_path = $invoice_ai_array['saved_file_path'];
            $quoteid = 0;

            $sqlMinQuoteId = "SELECT MIN(quoteid) AS min_quoteid FROM vtiger_quotes WHERE quote_no = '$quoteNumber'";
            $resultMinQuoteId = mysqli_query($conn, $sqlMinQuoteId);

            if ($resultMinQuoteId && $rowMinQuoteId = mysqli_fetch_assoc($resultMinQuoteId)) {
                $quoteid = $rowMinQuoteId['min_quoteid'] ?? 0;
            }

            if ($quoteid > 0) {
                $sqlVendor = "SELECT tv.vendorid FROM vtiger_inventoryproductrel vi
                              LEFT JOIN tdu_vendors tv ON vi.vendorid=tv.vendorid
                              WHERE vi.id = '$quoteid' AND tv.vendorName = '$invoiceVendorName';";
                $resultVendor = mysqli_query($conn, $sqlVendor);
                if ($resultVendor && mysqli_num_rows($resultVendor) > 0) {
                    $rowVendor = mysqli_fetch_assoc($resultVendor);
                    $vendorid = $rowVendor['vendorid'] ?? 0;

                    if ($vendorid > 0) {
                        // Clean and prepare values
                        $total_amount = floatval($invoiceTotal);
                        $remark = 'Auto extracted by AI';
                        $new_invoice_path = str_replace(',', '', $saved_file_path); // remove commas from filename just in case

                        // Check if a record already exists
                        $checkSql = "SELECT auto_id, invoice_path FROM vtiger_supplier_payment WHERE quoteid = '$quoteid' AND vendorid = '$vendorid'";
                        $checkResult = mysqli_query($conn, $checkSql);

                        if ($checkResult && mysqli_num_rows($checkResult) > 0) {
                            // Update existing record and append new file path
                            $row = mysqli_fetch_assoc($checkResult);
                            $existing_path = $row['invoice_path'];

                            // Prevent duplicates
                            $paths = array_filter(array_map('trim', explode(',', $existing_path)));
                            if (!in_array($new_invoice_path, $paths)) {
                                $paths[] = $new_invoice_path;
                            }
                            $updated_path = implode(',', $paths);

                            $updateSql = "UPDATE vtiger_supplier_payment 
                                        SET total_amount = '$total_amount', 
                                            remark = '$remark', 
                                            invoice_path = '$updated_path' 
                                        WHERE quoteid = '$quoteid' AND vendorid = '$vendorid'";
                            mysqli_query($conn, $updateSql);
                        } else {
                            // Insert new record
                            $insertSql = "INSERT INTO vtiger_supplier_payment (quoteid, vendorid, total_amount, remark, invoice_path)
                                        VALUES ('$quoteid', '$vendorid', '$total_amount', '$remark', '$new_invoice_path')";
                            mysqli_query($conn, $insertSql);
                        }
                    }
                }
            }
        }
        $insert_sql3 = "INSERT INTO vtiger_support (ticketid, quote_no, ai_actioned)
                        VALUES ('$conversation_id', '$quoteNumber', 1)
                        ON DUPLICATE KEY UPDATE quote_no = IF(quote_no IS NULL, '$quoteNumber', quote_no);";
        mysqli_query($conn, $insert_sql3);
    }
    if ($category_by_ai == 'confirmation' || $category_by_ai == 'both') {
        $confirmation_ai_array = processConversationForConfirmation($conversation_id, $conn);

        $confirmedProductSequences = [];
        if($confirmation_ai_array['confirmedProductSequences'] != 'N/A' && $confirmation_ai_array['matches'] == 'yes') {
            $confirmedProductSequences = array_map('intval', explode(',', $confirmation_ai_array['confirmedProductSequences']));
        }
        // $confirmedProductSequences[] = 5; /////

        if ($confirmedProductSequences != []) {
            $quoteConfirmationNumber = $confirmation_ai_array['confirmationNumber'];
            $quoteNumber = $confirmation_ai_array['quoteNumber'];
            foreach ($confirmedProductSequences as $productSequence) {
                $sqlMinQuoteId = "SELECT MIN(quoteid) AS min_quoteid FROM vtiger_quotes WHERE quote_no = '$quoteNumber'";
                $resultMinQuoteId = mysqli_query($conn, $sqlMinQuoteId);

                if ($resultMinQuoteId && $rowMinQuoteId = mysqli_fetch_assoc($resultMinQuoteId)) {
                    $quoteid = $rowMinQuoteId['min_quoteid'] ?? 0;

                    if ($quoteid > 0) {
                        $sqlSequenceNo = "SELECT sequence_no, cf_928, comment FROM vtiger_inventoryproductrel WHERE id = '$quoteid' AND sequence_no = '$productSequence';";
                        $resultSequenceNo = mysqli_query($conn, $sqlSequenceNo);

                        if ($resultSequenceNo && mysqli_num_rows($resultSequenceNo) > 0) {
                            while ($rowSequenceNo = mysqli_fetch_assoc($resultSequenceNo)) {
                                $sequence_no = $rowSequenceNo['sequence_no'];
                                $cf_928 = $rowSequenceNo['cf_928'];
                                $comment = $rowSequenceNo['comment'] ?? '';

                                if ($cf_928 == 'Transfers') {
                                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                                                    VALUES ('$quoteid', '$sequence_no', 0, 'booking_status', 'Confirmation received', NOW(), 'TAI extracted $email_inserted_sql_id')";
                                    mysqli_query($conn, $insert_sql);

                                    $insert_sql2 = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value, created_at, created_by) 
                                                    VALUES ('$quoteid', '$sequence_no', 0, 'comment', 'Confirmation Number: $quoteConfirmationNumber\n $comment', NOW(), 'TAI extracted $email_inserted_sql_id')";
                                    mysqli_query($conn, $insert_sql2);
                                } else {
                                    $insert_sql = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                                    VALUES ('$quoteid', '$sequence_no', 'booking_status', 'Confirmation received', NOW(), 'TAI extracted $email_inserted_sql_id')";
                                    mysqli_query($conn, $insert_sql);

                                    $insert_sql2 = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, meta_key, meta_value, created_at, created_by) 
                                                    VALUES ('$quoteid', '$sequence_no', 'confirmation_number', '$quoteConfirmationNumber', NOW(), 'TAI extracted $email_inserted_sql_id')";
                                    mysqli_query($conn, $insert_sql2);
                                }
                            }
                        }
                    }
                }
            }

            $insert_sql3 = "INSERT INTO vtiger_support (ticketid, quote_no, ai_actioned)
                            VALUES ('$conversation_id', '$quoteNumber', 1)
                            ON DUPLICATE KEY UPDATE quote_no = IF(quote_no IS NULL, '$quoteNumber', quote_no);";
            mysqli_query($conn, $insert_sql3);
        }
    }

    return [
        'status' => 'success',
        'confirmation_ai_array' => $confirmation_ai_array,
        'invoice_ai_array' => $invoice_ai_array
    ];
}
?>
