<?php
// Include database connection
include 'dbconn.php';

// Retrieve the input data from the AJAX request
$input = json_decode(file_get_contents('php://input'), true);
$rowId = $input['rowId'] ?? null;
$coachData = $input['coachData'] ?? null;

if ($rowId && $coachData) {
    // Extract details from row ID (quoteid, productid, sequence_no)
    list($quoteid, $productid, $sequence_no) = explode('_', $rowId);

    // Escape variables to prevent SQL injection
    $quoteid = mysqli_real_escape_string($conn, $quoteid);
    $sequence_no = mysqli_real_escape_string($conn, $sequence_no);

    // Initialize variable to calculate the new sale price
    $newSalePrice = 0;

    // Loop through the coach data and update each record in the database
    foreach ($coachData as $coach) {
        $seaters_number = intval($coach['seaters_number']);
        $coach_number = intval($coach['coach_number']);
        $price = floatval($coach['price']);

        // Update the coach info in the database (adjust query if necessary)
        $updateQuery = "
            INSERT INTO vtiger_coach_info (quoteid, sequence_no, seaters_number, coach_number, price)
            VALUES ('$quoteid', '$sequence_no', '$seaters_number', '$coach_number', '$price')
            ON DUPLICATE KEY UPDATE 
                seaters_number = VALUES(seaters_number), 
                coach_number = VALUES(coach_number), 
                price = VALUES(price)
        ";
        $result = mysqli_query($conn, $updateQuery);

        // Calculate new sale price (you can adjust this calculation as needed)
        $newSalePrice += $coach_number * $price;

        $updateQuery2 = "
            UPDATE vtiger_products_saleprice 
            SET sale_price = '$newSalePrice'
            WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no'
        ";
        $result2 = mysqli_query($conn, $updateQuery2);

        $updateQuery3 = "
            UPDATE vtiger_inventoryproductrel 
            SET quantity = '$coach_number'
            WHERE id = '$quoteid' AND sequence_no = '$sequence_no'
        ";
        $result3 = mysqli_query($conn, $updateQuery3);
    }

    // If the update was successful, return the new sale price
    if ($result) {
        echo json_encode(['new_sale_price' => $newSalePrice]);
    } else {
        // Handle query error
        echo json_encode(['error' => 'Failed to update coach info: ' . mysqli_error($conn)]);
    }
} else {
    // Handle missing parameters
    echo json_encode(['error' => 'Invalid parameters']);
}
?>
