<?php
include 'dbconn.php';

$quoteid = $_POST['quoteid'];
$sequence_no = $_POST['sequence_no'];
$flight_number = $_POST['flight_number'];
$from_city = $_POST['from_city'];
$from_datetime = $_POST['from_datetime'];
$to_city = $_POST['to_city'];
$to_datetime = $_POST['to_datetime'];
$flight_type = $_POST['flight_type'];

// Insert or update flight details in tdu_flight_details
$sql = "INSERT INTO tdu_flight_details 
        (quoteid, sequence_no, flight_number, from_city, from_datetime, to_city, to_datetime, flight_type)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE 
        flight_number = VALUES(flight_number), 
        from_city = VALUES(from_city), 
        from_datetime = VALUES(from_datetime), 
        to_city = VALUES(to_city), 
        to_datetime = VALUES(to_datetime),
        flight_type = VALUES(flight_type)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("iissssss", $quoteid, $sequence_no, $flight_number, $from_city, $from_datetime, $to_city, $to_datetime, $flight_type);
$stmt->execute();

// fill in pick up time
$inbound_outbound = $_POST['inbound_outbound'];
if($inbound_outbound == 'inbound') {
    $to_datetime_obj = new DateTime($to_datetime);
    if (strtolower($flight_type) === 'domestic') {
        $to_datetime_obj->modify('+30 minutes');
    } elseif (strtolower($flight_type) === 'international') {
        $to_datetime_obj->modify('+1 hour');
    }
} else {
    $to_datetime_obj = new DateTime($from_datetime);
    if (strtolower($flight_type) === 'domestic') {
        $to_datetime_obj->modify('-2 hour');
    } elseif (strtolower($flight_type) === 'international') {
        $to_datetime_obj->modify('-3 hour');
    }
}

$tourtime = $to_datetime_obj->format('H:i');
$sub_seq_no = 0;

// Insert into vtiger_itinerary
$meta_key = 'tourtime';
$insertItinerarySQL = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value) VALUES (?, ?, ?, ?, ?)";
$itineraryStmt = $conn->prepare($insertItinerarySQL);
$itineraryStmt->bind_param("iiiss", $quoteid, $sequence_no, $sub_seq_no, $meta_key, $tourtime);
$itineraryStmt->execute();

if($inbound_outbound == 'inbound') {
    $meta_key = 'pickup_location';
    $location = $to_city;
} else {
    $meta_key = 'dropoff_location';
    $location = $from_city;
}
$insertItinerarySQL = "INSERT INTO vtiger_itinerary (quoteid, sequence_no, sub_seq_no, meta_key, meta_value) VALUES (?, ?, ?, ?, ?)";
$itineraryStmt = $conn->prepare($insertItinerarySQL);
$itineraryStmt->bind_param("iiiss", $quoteid, $sequence_no, $sub_seq_no, $meta_key, $location);
$itineraryStmt->execute();

echo $tourtime;
?>
