<?php
include 'dbconn.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $productid = intval($_POST['productid']);
    $type = $_POST['type'];

    if (!$productid || !$type) {
        echo json_encode(["success" => false, "message" => "Missing required fields"]);
        exit;
    }

    if ($type === 'date_range') {
        $start_m = intval($_POST['start_m']);
        $start_d = intval($_POST['start_d']);
        $end_m = intval($_POST['end_m']);
        $end_d = intval($_POST['end_d']);

        if (!$start_m || !$start_d || !$end_m || !$end_d) {
            echo json_encode(["success" => false, "message" => "Missing date range fields"]);
            exit;
        }

        $sql = "INSERT INTO tdu_products_non_operation (productid, start_m, start_d, end_m, end_d) 
                VALUES (?, ?, ?, ?, ?)";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iiiii", $productid, $start_m, $start_d, $end_m, $end_d);

    } elseif ($type === 'day_of_week') {
        $day_of_week = $_POST['day_of_week'];

        if (!$day_of_week) {
            echo json_encode(["success" => false, "message" => "Missing day of week"]);
            exit;
        }

        // Store nulls for date fields if it's a day-of-week entry.
        $sql = "INSERT INTO tdu_products_non_operation (productid, day_week) 
                VALUES (?, ?)";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("is", $productid, $day_of_week);

    } else {
        echo json_encode(["success" => false, "message" => "Invalid type"]);
        exit;
    }

    if ($stmt->execute()) {
        echo json_encode(["success" => true]);
    } else {
        echo json_encode(["success" => false, "message" => "Failed to save"]);
    }

    $stmt->close();
    $conn->close();

} else {
    echo json_encode(["success" => false, "message" => "Invalid request"]);
}
?>
