<?php
header('Content-Type: application/json');
include 'dbconn.php';

$vendorid = $_POST['vendorid'] ?? '';
$start_m = $_POST['start_m'] ?? '';
$start_d = $_POST['start_d'] ?? '';
$end_m = $_POST['end_m'] ?? '';
$end_d = $_POST['end_d'] ?? '';
$amount = $_POST['amount'] ?? '';
$apply_to = $_POST['apply_to'] ?? 'custom';

if (!$vendorid || !$start_m || !$start_d || !$end_m || !$end_d || $amount === '') {
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}

// Prevent SQL injection (optional, but safe)
$vendorid = mysqli_real_escape_string($conn, $vendorid);
$start_m = mysqli_real_escape_string($conn, $start_m);
$start_d = mysqli_real_escape_string($conn, $start_d);
$end_m = mysqli_real_escape_string($conn, $end_m);
$end_d = mysqli_real_escape_string($conn, $end_d);
$amount = mysqli_real_escape_string($conn, $amount);

$sql = "INSERT INTO tdu_vendors_surcharge (vendorid, start_m, start_d, end_m, end_d, surcharge) 
        VALUES ('$vendorid', '$start_m', '$start_d', '$end_m', '$end_d', '$amount')";

if (mysqli_query($conn, $sql)) {
    $surcharge_id = mysqli_insert_id($conn);

    if ($apply_to === 'all') {
        // Get all products for this vendor
        $productQuery = "SELECT productid FROM tdu_products WHERE vendorid = '$vendorid'";
        $result = mysqli_query($conn, $productQuery);

        if ($result) {
            while ($row = mysqli_fetch_assoc($result)) {
                $productid = $row['productid'];
                $linkSql = "INSERT IGNORE INTO tdu_products_surcharge (productid, surcharge_id) 
                            VALUES ('$productid', '$surcharge_id')";
                mysqli_query($conn, $linkSql); // We ignore individual insert errors here
            }
        }
    }

    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => mysqli_error($conn)]);
}
?>
