<?php
include 'dbconn.php'; // Ensure this file connects to your database

if (isset($_GET['query'])) {
    $searchQuery = trim($_GET['query']);

    if (!empty($searchQuery)) {
        $sql = "SELECT vendorid, vendorName FROM tdu_vendors 
                WHERE vendorName LIKE ? 
                ORDER BY vendorName LIMIT 20";
        $stmt = mysqli_prepare($conn, $sql);
        $param = "%$searchQuery%";
        mysqli_stmt_bind_param($stmt, "s", $param);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                echo "<div class='vendor-item' data-vendorid='" . $row['vendorid'] . "' 
                      style='padding: 10px; border-bottom: 1px solid #ddd; cursor: pointer;'>
                      " . htmlspecialchars($row['vendorName']) . "
                      </div>";
            }
        } else {
            echo "<div style='padding: 5px;'>No vendors found</div>";
        }

        mysqli_stmt_close($stmt);
        mysqli_close($conn);
    }
}
?>
