<?php
// fetch_products.php
include 'dbconn.php'; // Adjust this line to include your database connection

if (isset($_GET['vendor_id'])) {
    $vendor_id = intval($_GET['vendor_id']);
    $sql = "SELECT product_name, sub_category, price FROM tdu_product WHERE vendor_id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $vendor_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $products = [];
    while ($row = $result->fetch_assoc()) {
        $products[] = $row;
    }
    
    // Return products as JSON
    echo json_encode($products);
}
?>
