<?php
// ajax_supplier_breakdown.php

// 1. Establish Database Connection (CRITICAL: NO HTML OUTPUT from this include)
// Replace 'config.php' with your actual DB connection file
require_once 'dbconn.php'; // This file should ONLY set up $conn

// 2. Check if $conn is valid (optional, but good practice)
if (!isset($conn) || !$conn) {
    header('HTTP/1.1 500 Internal Server Error');
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['success' => false, 'error' => 'Database connection failed in AJAX handler.']);
    exit;
}

// 3. Set Content Type to JSON
header('Content-Type: application/json; charset=utf-8');

// 4. Process the request
$response = ['success' => false, 'items' => [], 'error' => 'Invalid request.']; // Default response

if (isset($_REQUEST['quoteid_for_breakdown_ACCREP_202405_PARAM'])) {
    $quoteIdForBreakdown = $conn->real_escape_string($_REQUEST['quoteid_for_breakdown_ACCREP_202405_PARAM']);
    $breakdownSql = "SELECT
                        ven.vendorname,
                        SUM(vsp.total_amount) AS supplier_invoice_amount
                    FROM
                        vtiger_supplier_payment AS vsp
                    JOIN
                        (SELECT vendorid, vendorname FROM vtiger_vendor_custom
                         UNION ALL
                         SELECT vendorid, vendorName AS vendorname FROM tdu_vendors) AS ven
                    ON vsp.vendorid = ven.vendorid
                    WHERE
                        vsp.quoteid = '$quoteIdForBreakdown'
                    GROUP BY
                        vsp.vendorid, ven.vendorname
                    HAVING
                        SUM(vsp.total_amount) > 0;";

    $breakdownResult = $conn->query($breakdownSql);
    
    if ($breakdownResult) {
        $items = [];
        while ($breakdownRow = $breakdownResult->fetch_assoc()) {
            $items[] = $breakdownRow;
        }
        $response['success'] = true;
        $response['items'] = $items;
        $response['error'] = ''; // Clear default error
    } else {
        $response['error'] = "Query failed: " . $conn->error;
        $response['debug_query'] = $breakdownSql; // For debugging
    }
} else {
    $response['error'] = "Required parameter 'quoteid_for_breakdown_ACCREP_202405_PARAM' is missing.";
}

// 5. Encode and Echo Response
echo json_encode($response);
exit; // Ensure no further output
?>