<?php
include "dbconn.php";
session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}
$username = $_SESSION['user_name'];
$sql_ajax = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $username_ajax = $row_ajax['name'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $taskIds = isset($_POST['task_ids']) ? explode(',', $_POST['task_ids']) : [];
    $newCategory = isset($_POST['category']) ? trim($_POST['category']) : '';

    if (empty($taskIds) || empty($newCategory)) {
        echo "error";
        exit;
    }

    $taskIds = array_map('intval', $taskIds); // Ensure task IDs are integers
    $taskIdsString = implode(',', $taskIds);

    // Start transaction to ensure consistency
    mysqli_begin_transaction($conn);

    try {
        // Update the category for tasks
        $sql = "UPDATE tdu_tasks_management SET category = '" . mysqli_real_escape_string($conn, $newCategory) . "' WHERE task_id IN ($taskIdsString)";
        if (mysqli_query($conn, $sql)) {
            // Log each task change in tdu_tasks_management_history
            foreach ($taskIds as $taskId) {
                // Prepare the log entry
                $details = "Category bulk changed to $newCategory";

                // Insert the history log
                $historySql = "INSERT INTO tdu_tasks_management_history (task_id, details, created_at, created_by) 
                               VALUES ($taskId, '" . mysqli_real_escape_string($conn, $details) . "', NOW(), '$username_ajax')";
                mysqli_query($conn, $historySql);
            }
            // Commit transaction if all queries are successful
            mysqli_commit($conn);
            echo "success";
        } else {
            // Rollback transaction if update fails
            mysqli_rollback($conn);
            echo "error";
        }
    } catch (Exception $e) {
        // Rollback in case of an error
        mysqli_rollback($conn);
        echo "error";
    }
}
?>
