<?php
include 'dbconn.php';

// Ensure POST method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$action = $_POST['action'] ?? '';
$id = $_POST['id'] ?? null;

// Escape helper
function sanitize($conn, $str) {
    return mysqli_real_escape_string($conn, trim($str));
}

switch ($action) {
    case 'add':
        $quotestage = sanitize($conn, $_POST['quotestage'] ?? '');
        $region = sanitize($conn, $_POST['assigned_to_region'] ?? '');
        $user = sanitize($conn, $_POST['assigned_to_user'] ?? '');

        if ($quotestage && $region) {
            $sql = "INSERT INTO tdu_tasks_management_define_rule (quotestage, assigned_to_region, assigned_to_user, message)
                    VALUES ('$quotestage', '$region', '$user', 'Quote $quotestage, Please action')";
            $result = mysqli_query($conn, $sql);
            if ($result) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Insert failed: ' . mysqli_error($conn)]);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Missing required fields']);
        }
        break;

    case 'update':
        $quotestage = sanitize($conn, $_POST['quotestage'] ?? '');
        $region = sanitize($conn, $_POST['region'] ?? '');
        $user = sanitize($conn, $_POST['user'] ?? '');
        $message = isset($_POST['message']) ? mysqli_real_escape_string($conn, $_POST['message']) : '';
    
        if ($id) {
            // Fetch current task_category
            $check_sql = "SELECT category AS task_category FROM tdu_tasks_management_define_rule WHERE auto_id = '$id'";
            $check_result = mysqli_query($conn, $check_sql);
    
            if ($check_result && mysqli_num_rows($check_result) > 0) {
                $row = mysqli_fetch_assoc($check_result);
    
                if ($row['task_category'] === 'custom') {
                    $sql = "UPDATE tdu_tasks_management_define_rule
                            SET assigned_to_region = '$region',
                                assigned_to_user = '$user'
                            WHERE auto_id = '$id'";
                } else {
                    $sql = "UPDATE tdu_tasks_management_define_rule
                            SET quotestage = '$quotestage',
                                assigned_to_region = '$region',
                                assigned_to_user = '$user',
                                message = '$message'
                            WHERE auto_id = '$id'";
                }
                $result = mysqli_query($conn, $sql);
                if ($result) {
                    echo json_encode(['success' => true]);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Update failed: ' . mysqli_error($conn)]);
                }
            } else {
                echo json_encode(['success' => false, 'message' => 'Task not found']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Missing required fields']);
        }
        break;

    case 'delete':
        if ($id) {
            $sql = "DELETE FROM tdu_tasks_management_define_rule WHERE auto_id = '$id'";
            $result = mysqli_query($conn, $sql);
            if ($result) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Delete failed: ' . mysqli_error($conn)]);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Missing ID']);
        }
        break;

    case 'toggle_active':
        $active = isset($_POST['active']) ? (int)$_POST['active'] : null;
    
        if ($id !== null && ($active === 0 || $active === 1)) {
            $sql = "UPDATE tdu_tasks_management_define_rule SET active = '$active' WHERE auto_id = '$id'";
            $result = mysqli_query($conn, $sql);
            if ($result) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to update active state']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid input']);
        }
        break;        

    default:
        echo json_encode(['success' => false, 'message' => 'Unknown action']);
}
?>
