<?php
include 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $templateId = isset($_POST['templateid']) ? intval($_POST['templateid']) : 0;
    $copyTemplateId = isset($_POST['copy_templateid']) ? intval($_POST['copy_templateid']) : 0;
    $templateDay = isset($_POST['template_day']) ? intval($_POST['template_day']) : -1;
    $targetDay = isset($_POST['target_day']) ? intval($_POST['target_day']) : -1;

    if ($templateId <= 0 || $copyTemplateId <= 0 || $templateDay < 0 || $targetDay < 0) {
        echo "Invalid input values.";
        exit;
    }

    $sql = "SELECT MAX(sequence_no) AS max_sequence FROM tdu_template_products WHERE templateid=$templateId AND day=$targetDay AND productid != 0;";
    $result = mysqli_query($conn, $sql);
    $maxSequence = 99;
    if ($row = mysqli_fetch_assoc($result)) {
        $maxSequence = (int) $row['max_sequence'];
    }

    // Copy events from copyTemplateId/templateDay into templateId/targetDay
    $sql = "INSERT INTO tdu_template_products (templateid, day, sequence_no, productid, event_time, event_name)
            SELECT ?, ?, ?, productid, event_time, event_name 
            FROM tdu_template_products 
            WHERE templateid = ? AND productid = 0 AND day = ?";

    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("iiiii", $templateId, $targetDay, $maxSequence, $copyTemplateId, $templateDay);
        if ($stmt->execute()) {
            echo "Events copied from day $templateDay to day $targetDay successfully.";
        } else {
            echo "Error copying events: " . $stmt->error;
        }
        $stmt->close();
    } else {
        echo "Error preparing statement: " . $conn->error;
    }

    $conn->close();
} else {
    echo "Invalid request method.";
}
