<?php
include 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = intval($_POST['user_id']);
    $fileAccess = $_POST['file_access']; 

    // Validate allowed values to prevent SQL injection
    $allowedValues = ['all', 'assigned_created', 'assigned_only', 'created_only'];
    if (!in_array($fileAccess, $allowedValues)) {
        echo json_encode(['success' => false, 'message' => 'Invalid access type']);
        exit;
    }

    // Prepare SQL query to update file_access
    $sql = "UPDATE vtiger_users SET file_access = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $fileAccess, $userId);

    $response = ['success' => $stmt->execute()];
    echo json_encode($response);

    $stmt->close();
    $conn->close();
}
?>
