<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['product_ids'], $_POST['parent_product_id'])) {
        $productIds = $_POST['product_ids'];
        $parentProductName = trim($_POST['parent_product_id']);

        // Sanitize input
        $productIdsArray = array_map('intval', explode(',', $productIds));
        $productIdsList = implode(',', $productIdsArray);
        $escapedParentProductName = $conn->real_escape_string($parentProductName);

        // Check if the parent product already exists
        $checkQuery = "SELECT parentid FROM tdu_products_parent WHERE parent_name = '$escapedParentProductName'";
        $result = mysqli_query($conn, $checkQuery);

        if ($row = mysqli_fetch_assoc($result)) {
            // Parent product exists, get the parentid
            $parentId = $row['parentid'];
        } else {
            // Insert new parent product and get its ID
            $insertQuery = "INSERT INTO tdu_products_parent (parent_name) VALUES ('$escapedParentProductName')";
            if (mysqli_query($conn, $insertQuery)) {
                $parentId = mysqli_insert_id($conn); // Get the newly inserted ID
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to insert new parent product: ' . mysqli_error($conn)]);
                exit;
            }
        }

        // Update the selected products with the new parentid
        $updateQuery = "UPDATE tdu_products SET parentid = '$parentId' WHERE productid IN ($productIdsList)";
        if (mysqli_query($conn, $updateQuery)) {
            echo json_encode(['success' => true, 'message' => 'Parent product assigned successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update parent product: ' . mysqli_error($conn)]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid input. Product IDs and parent product name are required.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}

mysqli_close($conn);
