<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    // Trim and sanitize input values
    $productName = trim($input['productName']);
    $subcategory = trim($input['subcategory']);
    $category = trim($input['category']);
    $city = trim($input['city']);
    $country = trim($input['country']);
    $description = trim($input['description']);
    $keywords = trim($input['keywords']);
    $productActive = isset($input['productActive']) ? trim($input['productActive']) : '';
    $productID = intval($input['productID']); // Ensure productID is an integer
    $childOnly = isset($input['childOnly']) ? intval($input['childOnly']) : 0;

    // Set default values for child age range
    $childOnlyAgeMin = isset($input['childOnlyAgeMin']) ? intval($input['childOnlyAgeMin']) : 0;
    $childOnlyAgeMax = isset($input['childOnlyAgeMax']) ? intval($input['childOnlyAgeMax']) : 7;

    // Escape input values to prevent SQL injection
    $productName = $conn->real_escape_string($productName);
    $category = $conn->real_escape_string($category);
    $city = $conn->real_escape_string($city);
    $country = $conn->real_escape_string($country);
    $description = $conn->real_escape_string($description);
    $keywords = $conn->real_escape_string($keywords);

    // Prepare the SQL query
    $sql = "UPDATE tdu_products 
            SET productName = '$productName', 
                category = '$category', subcategory = '$subcategory',
                city = '$city', country = '$country', 
                description = '$description', 
                productActive = '$productActive',
                keywords = '$keywords',
                childOnly = '$childOnly'";

    // Append child age range only if childOnly is enabled
    if ($childOnly == 1) {
        $sql .= ", childOnlyAgeMin = '$childOnlyAgeMin', childOnlyAgeMax = '$childOnlyAgeMax'";
    }

    $sql .= " WHERE productid = $productID";

    // Execute the query
    $success = mysqli_query($conn, $sql);

    // Close the connection
    $conn->close();

    // Return the response
    if ($success) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
    }
}
?>
