<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if required data is provided
    if (isset($_POST['product_ids'], $_POST['new_keywords'])) {
        $productIds = $_POST['product_ids'];
        $newKeyword = trim($_POST['new_keywords']);

        // Sanitize input
        $productIdsArray = array_map('intval', explode(',', $productIds));
        $productIdsList = implode(',', $productIdsArray);

        // Escape the new keyword
        $escapedKeyword = $conn->real_escape_string($newKeyword);

        // Build the SQL query to handle empty or non-empty keywords
        $sql = "UPDATE tdu_products 
                SET keywords = 
                CASE 
                    WHEN keywords IS NULL OR TRIM(keywords) = '' THEN '$escapedKeyword'
                    ELSE CONCAT(keywords, ', ', '$escapedKeyword')
                END 
                WHERE productid IN ($productIdsList)";

        // Execute the query
        if (mysqli_query($conn, $sql)) {
            echo json_encode(['success' => true, 'message' => 'Keyword added successfully.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to add keyword: ' . mysqli_error($conn)]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid input. Product IDs and keyword are required.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}

// Close the database connection
mysqli_close($conn);
