<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = $_POST['product_id'] ?? null;
    if (!$product_id) {
        echo "ERROR: Invalid product ID.";
        exit;
    }

    $updateFields = [];
    $pricingFields = [
        "unitPrice", "childPrice", "infantPrice", "familyPrice",
        "duration", "seats",
        "sharingPrice", "triplePrice", "childWithBedPrice", "childNoBedPrice",
        "childAge", "infantAge"
    ];

    foreach ($pricingFields as $field) {
        if (isset($_POST[$field])) {
            $updateFields[] = "$field = '" . mysqli_real_escape_string($conn, $_POST[$field]) . "'";
        } else {
            $updateFields[] = "$field = ''";
        }
    }

    if (empty($updateFields)) {
        echo "ERROR: No valid pricing fields provided.";
        exit;
    }

    $sql = "UPDATE tdu_products SET " . implode(", ", $updateFields) . " WHERE productid = '" . mysqli_real_escape_string($conn, $product_id) . "'";

    if (mysqli_query($conn, $sql)) {
        echo "SUCCESS: Pricing updated successfully.";
    } else {
        echo "ERROR: Database error: " . mysqli_error($conn);
    }
} else {
    echo "ERROR: Invalid request method.";
}
?>
