<?php
include "dbconn.php";
include "dictionaries.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'];
    $tagID = $_POST['tag_id'] ?? null;
    $ticketID = $_POST['ticket_id'] ?? null;
    $tagName = $_POST['tag_name'] ?? null;
    $tag_category = $_POST['tag_category'] ?? null;
    $category = $_POST['category'] ?? null;
    $username_ajax = $_POST['username_ajax'] ?? '';
    $main_mailbox = $_POST['main_mailbox'] ?? '';

    if ($action === 'fetch' && !empty($category)) {
        $category = mysqli_real_escape_string($conn, $category);
        $main_mailbox = mysqli_real_escape_string($conn, $main_mailbox);

        $titleAllowed = [];

        $salesMailboxes = [
            'sales@turtledownunder.com.au',
            'groupsales@turtledownunder.com.au',
            'asia@turtledownunder.com.au'
        ];

        $fitMailboxes = [
            'operations@turtledownunder.com.au',
            'operations@turtledownunder.co.nz'
        ];

        $groupMailboxes = [
            'groups@turtledownunder.com.au',
            'groups@turtledownunder.co.nz',
            'operations@turtledownunder.com.au',
            'operations@turtledownunder.co.nz'
        ];

        if (in_array($main_mailbox, $salesMailboxes)) {
            $titleAllowed = ['admin', 'sales', 'external', 'qa'];
        } elseif (in_array($main_mailbox, $fitMailboxes)) {
            $titleAllowed = ['admin', 'fit', 'qa'];
        } elseif (in_array($main_mailbox, $groupMailboxes)) {
            $titleAllowed = ['admin', 'group', 'qa'];
        }

        if ($category == 'all') {
            $sql = "SELECT id, tag, raw_tag, '' AS title FROM vtiger_freetags WHERE visibility = 'public' ORDER BY raw_tag, tag";
        } else if (!empty($titleAllowed) && $category == 'person') {
            $titles = array_map(function ($title) use ($conn) {
                return "'" . mysqli_real_escape_string($conn, $title) . "'";
            }, $titleAllowed);
        
            $titleList = implode(",", $titles);
        
            $sql = "SELECT f.id, f.tag, u.title 
                    FROM vtiger_freetags f
                    JOIN vtiger_users u 
                      ON CONCAT(u.first_name, ' ', u.last_name) = f.tag
                    WHERE u.title IN ($titleList)
                      AND f.raw_tag = '$category' AND f.visibility = 'public'
                    ORDER BY u.title, f.tag";
        } else {
            $sql = "SELECT id, tag, '' AS title FROM vtiger_freetags WHERE raw_tag = '$category' AND visibility = 'public' ORDER BY tag";
        }
        
        $result = mysqli_query($conn, $sql);
        
        $tags = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $tags[] = [
                'id' => $row['id'],
                'tag_name' => $row['tag'],
                'raw_tag' => $row['raw_tag'] ?? '',
                'title' => $row['title']
            ];
        }

        echo json_encode($tags);
    } elseif ($action === 'add' && !empty($tagID) && !empty($ticketID)) {
        // Add the tag to the ticket
        $tagID = mysqli_real_escape_string($conn, $tagID);
        $ticketID = mysqli_real_escape_string($conn, $ticketID);

        $sql = "INSERT INTO vtiger_freetagged_objects (object_id, tag_id, tagged_on, module) VALUES ('$ticketID', '$tagID', NOW(), 'Dashboard')";
        
        if (mysqli_query($conn, $sql)) {
            $getTagByTagID = getTagByTagID($conn);
            $sql_history = "INSERT INTO vtiger_support_history (conversation_id, details, created_by) VALUES ('$ticketID', 'Add Tag " . $getTagByTagID[$tagID] . "', '$username_ajax')";
            mysqli_query($conn, $sql_history);

            $check_sql = "SELECT * FROM vtiger_support WHERE ticketid = '$ticketID'";
            $check_result = mysqli_query($conn, $check_sql);

            if (mysqli_num_rows($check_result) === 0) {
                $insert_sql = "INSERT INTO vtiger_support (ticketid, status, created_at, status_updated_at) VALUES ('$ticketID', 'In Progress', NOW(), NOW())";
                mysqli_query($conn, $insert_sql);
            } else {
                $row = mysqli_fetch_assoc($check_result);
                if (!isset($row['status']) || empty($row['status'])) {
                    $update_sql = "UPDATE vtiger_support SET status = 'In Progress' WHERE ticketid = '$ticketID'";
                    mysqli_query($conn, $update_sql);
                }
            }

            echo 'Tag Added';
        } else {
            echo 'Failed to process the request!';
        }
    } elseif ($action === 'remove' && !empty($tagID) && !empty($ticketID)) {
        // Remove the tag from the ticket
        $tagID = mysqli_real_escape_string($conn, $tagID);
        $ticketID = mysqli_real_escape_string($conn, $ticketID);

        $sql = "DELETE FROM vtiger_freetagged_objects WHERE object_id = '$ticketID' AND tag_id = '$tagID'";
        
        if (mysqli_query($conn, $sql)) {
            $getTagByTagID = getTagByTagID($conn);
            $sql_history = "INSERT INTO vtiger_support_history (conversation_id, details, created_by) VALUES ('$ticketID', 'Delete Tag " . $getTagByTagID[$tagID] . "', '$username_ajax')";
            mysqli_query($conn, $sql_history);

            echo 'Tag Removed';
        } else {
            echo 'Failed to process the request!';
        }
    } elseif ($action === 'create' && !empty($tagName)) {
        // Create a new tag
        $tagName = mysqli_real_escape_string($conn, $tagName);

        // Get the max id from vtiger_freetags
        $sqlMaxId = "SELECT MAX(id) AS max_id FROM vtiger_freetags";
        $resultMaxId = mysqli_query($conn, $sqlMaxId);
        $maxId = 0; // Default value in case the table is empty

        if ($resultMaxId && $row = mysqli_fetch_assoc($resultMaxId)) {
            $maxId = $row['max_id'];
        }

        // Set the new ID as max(id) + 1
        $newId = $maxId + 1;

        // Insert the new tag with the calculated ID
        $sql = "INSERT INTO vtiger_freetags (id, tag, raw_tag, visibility) VALUES ('$newId', '$tagName', '$tag_category', 'public')";
        
        if (mysqli_query($conn, $sql)) {
            echo 'Tag Created';
        } else {
            echo 'Failed to process the request!';
        }
    }
}
?>
