<?php
include "dbconn.php";
session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}
$username = $_SESSION['user_name'];
$sql_ajax = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $username_ajax = $row_ajax['name'];
}

$data = json_decode(file_get_contents('php://input'), true);

$task_id = $data['task_id'];
$quote_no = mysqli_real_escape_string($conn, $data['quote_no']);
$assigned_to_user = mysqli_real_escape_string($conn, $data['assigned_to_user']);
$assigned_to_region = mysqli_real_escape_string($conn, $data['assigned_to_region']);
$category = mysqli_real_escape_string($conn, $data['category']);
$priority = mysqli_real_escape_string($conn, $data['priority']);
$status = mysqli_real_escape_string($conn, $data['status']);
$deadline = mysqli_real_escape_string($conn, $data['deadline']);

// Get the current values from the database for comparison
$sql_select = "SELECT * FROM tdu_tasks_management WHERE task_id = $task_id";
$result = mysqli_query($conn, $sql_select);
$old_data = mysqli_fetch_assoc($result);

// Initialize an array to store change log messages
$change_log = [];

// Compare the old and new values, if different, log the change
if ($quote_no !== $old_data['quote_no']) {
    $change_log[] = "Quote No changed from {$old_data['quote_no']} to $quote_no";
}
if ($assigned_to_user !== $old_data['assigned_to_user']) {
    $change_log[] = "Assigned User changed from {$old_data['assigned_to_user']} to $assigned_to_user";
}
if ($assigned_to_region !== $old_data['assigned_to_region']) {
    $change_log[] = "Assigned Region changed from {$old_data['assigned_to_region']} to $assigned_to_region";
}
if ($category !== $old_data['category']) {
    $change_log[] = "Category changed from {$old_data['category']} to $category";
}
if ($priority !== $old_data['priority']) {
    $change_log[] = "Priority changed from {$old_data['priority']} to $priority";
}
if ($status !== $old_data['status']) {
    $change_log[] = "Status changed from {$old_data['status']} to $status";
}
if ($deadline != $old_data['deadline']) {
    $change_log[] = "Deadline changed from {$old_data['deadline']} to $deadline";
}

// Construct the SQL update query
$sql_update = "UPDATE tdu_tasks_management 
               SET quote_no = '$quote_no', 
                   assigned_to_user = '$assigned_to_user', 
                   assigned_to_region = '$assigned_to_region', 
                   category = '$category', 
                   priority = '$priority', 
                   status = '$status'";

if ($deadline === '') {
    $sql_update .= ", deadline = NULL";
} else {
    $sql_update .= ", deadline = '$deadline'";
}

$sql_update .= " WHERE task_id = $task_id";

// Perform the update query
if (mysqli_query($conn, $sql_update)) {
    // Log changes to the history table if any changes were made
    if (!empty($change_log)) {
        $change_message = implode("\n", $change_log);
        $change_message = mysqli_real_escape_string($conn, $change_message);
        $sql_history = "INSERT INTO tdu_tasks_management_history (task_id, details, created_at, created_by) 
                        VALUES ($task_id, '$change_message', NOW(), '$username_ajax')";
        mysqli_query($conn, $sql_history);
    }
    
    // Respond with success
    echo json_encode(['success' => true]);
} else {
    // Respond with failure
    echo json_encode(['success' => false, 'error' => mysqli_error($conn)]);
}

mysqli_close($conn);
?>
