<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (!isset(
        $data['template_id'], $data['templatename'], $data['category'], $data['country'],
        $data['seaters'], $data['nights'], $data['preferred'],
        $data['start_month'], $data['end_month'], $data['replace_templateid']
    )) {
        echo json_encode(['success' => false, 'message' => 'Invalid input']);
        exit;
    }

    $template_id = (int) $data['template_id'];
    $templatename = mysqli_real_escape_string($conn, $data['templatename']);
    $category = mysqli_real_escape_string($conn, $data['category']);
    $country = mysqli_real_escape_string($conn, $data['country']);
    $seaters = (int) $data['seaters'];
    $nights = (int) $data['nights'];
    $preferred = (int) $data['preferred'];
    $start_month = (int) $data['start_month'];
    $end_month = (int) $data['end_month'];
    $replace_templateid = (int) $data['replace_templateid'];

    if ($replace_templateid <= 0 && $start_month > 0 && $end_month > 0) {
        echo json_encode(['success' => false, 'message' => 'Invalid Template ID']);
        exit;
    }

    if ($preferred !== 1 && $preferred !== 0) {
        echo json_encode(['success' => false, 'message' => 'Invalid preferred value']);
        exit;
    }

    if ($start_month > 0 && $end_month > 0 && $replace_templateid > 0) {
        $check_sql = "SELECT start_month, end_month FROM tdu_templates WHERE templateid = $replace_templateid";
        $result = mysqli_query($conn, $check_sql);
        
        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            $r_start = (int) $row['start_month'];
            $r_end = (int) $row['end_month'];

            $new_months = get_month_range($start_month, $end_month);
            $existing_months = get_month_range($r_start, $r_end);

            // Check for overlap
            $overlap = array_intersect($new_months, $existing_months);
            if (!empty($overlap)) {
                echo json_encode(['success' => false, 'message' => 'Start and End months overlap with the Replace Template.']);
                exit;
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Replace Template not found.']);
            exit;
        }
    }

    $sql = "UPDATE tdu_templates 
            SET templatename = '$templatename',
                category = '$category',
                country = '$country',
                seaters = $seaters,
                nights = $nights,
                preferred = $preferred,
                start_month = $start_month,
                end_month = $end_month,
                replace_templateid = $replace_templateid
            WHERE templateid = $template_id";

    if (mysqli_query($conn, $sql)) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => mysqli_error($conn)]);
    }
}

function get_month_range($start, $end) {
    $months = [];
    if ($start <= $end) {
        for ($i = $start; $i <= $end; $i++) {
            $months[] = $i;
        }
    } else {
        for ($i = $start; $i <= 12; $i++) {
            $months[] = $i;
        }
        for ($i = 1; $i <= $end; $i++) {
            $months[] = $i;
        }
    }
    return $months;
}
?>
