<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $templateIds = isset($_POST['templateIds']) ? explode(',', $_POST['templateIds']) : [];
    $newCategory = isset($_POST['newCategory']) ? $_POST['newCategory'] : '';

    if (empty($templateIds) || empty($newCategory)) {
        echo 'Invalid input';
        exit;
    }

    // Prepare the query to update the selected templates
    $stmt = $conn->prepare("UPDATE tdu_templates SET category = ? WHERE templateid IN (" . implode(',', array_fill(0, count($templateIds), '?')) . ")");
    $params = array_merge([$newCategory], $templateIds);

    $stmt->bind_param(str_repeat('s', count($params)), ...$params);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo 'Category updated successfully';
    } else {
        echo 'No templates updated';
    }

    $stmt->close();
}
?>
