<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $templateIds = isset($_POST['templateIds']) ? explode(',', $_POST['templateIds']) : [];
    $newType = isset($_POST['newType']) ? $_POST['newType'] : '';

    if (empty($templateIds) || empty($newType)) {
        echo 'Invalid input';
        exit;
    }

    // Prepare the query to update the selected templates
    $stmt = $conn->prepare("UPDATE tdu_templates SET type = ? WHERE templateid IN (" . implode(',', array_fill(0, count($templateIds), '?')) . ")");
    $params = array_merge([$newType], $templateIds);

    $stmt->bind_param(str_repeat('s', count($params)), ...$params);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo 'Type updated successfully';
    } else {
        echo 'No templates updated';
    }

    $stmt->close();
}
?>
