<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $quote_view = mysqli_real_escape_string($conn, $_POST['salesGroup']);
    $reassignTo = mysqli_real_escape_string($conn, $_POST['reassignTo']);

    if($quote_view == '') {
        $quote_view = 'both';
    }

    // Fetch the full name of the user being updated
    $sql_get_user = "SELECT CONCAT(first_name, ' ', last_name) AS full_name FROM vtiger_users WHERE id = $id";
    $result = mysqli_query($conn, $sql_get_user);
    
    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $old_username = $row['full_name'];

        // Update the user's title and quote view
        $sql_update_user = "UPDATE vtiger_users SET title = '$title', quote_view = '$quote_view' WHERE id = $id";
        if (mysqli_query($conn, $sql_update_user)) {
            // If reassignTo is set, update the auto-assign rules
            if (!empty($reassignTo)) {
                $sql_update_tasks = "UPDATE tdu_auto_assign_rules SET username = '$reassignTo' WHERE username = '$old_username'";
                mysqli_query($conn, $sql_update_tasks);

                $sql_update =  "UPDATE vtiger_quotes_info vqinfo
                                JOIN vtiger_quotescf vqcf ON vqinfo.quoteid = vqcf.quoteid
                                SET
                                    vqinfo.assigned_to_sales_agent = CASE 
                                        WHEN vqinfo.assigned_to_sales_agent = '$old_username' THEN '$reassignTo'
                                        ELSE vqinfo.assigned_to_sales_agent
                                    END,
                                    vqinfo.assigned_to_external_sales_agent = CASE 
                                        WHEN vqinfo.assigned_to_external_sales_agent = '$old_username' THEN '$reassignTo'
                                        ELSE vqinfo.assigned_to_external_sales_agent
                                    END,
                                    vqinfo.assigned_to_ops = CASE 
                                        WHEN vqinfo.assigned_to_ops = '$old_username' THEN '$reassignTo'
                                        ELSE vqinfo.assigned_to_ops
                                    END,
                                    vqinfo.assigned_to_qa = CASE 
                                        WHEN vqinfo.assigned_to_qa = '$old_username' THEN '$reassignTo'
                                        ELSE vqinfo.assigned_to_qa
                                    END
                                WHERE 
                                    vqinfo.quotetype = 'group'
                                    AND vqcf.cf_1162 >= CURDATE()
                                    AND (
                                        vqinfo.assigned_to_sales_agent = '$old_username' OR
                                        vqinfo.assigned_to_external_sales_agent = '$old_username' OR
                                        vqinfo.assigned_to_ops = '$old_username' OR
                                        vqinfo.assigned_to_qa = '$old_username'
                                    );";
                mysqli_query($conn, $sql_update);
                
                $affected_rows = mysqli_affected_rows($conn);
                error_log("Reassigned $affected_rows row(s) from '$old_username' to '$reassignTo' in vtiger_quotes_info.");
            }
            echo "Success";
        } else {
            echo "Error updating user: " . mysqli_error($conn);
        }
    } else {
        echo "Error fetching user details: " . mysqli_error($conn);
    }
}
?>
