<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['quoteid']) && isset($_GET['vendorid'])) {
    $quoteid = $_GET['quoteid'];
    $vendorid_index = $_GET['vendorid'];

    $date_sql = "SELECT vq.quote_no, vq.subject, vqcf.cf_1162 AS date_of_travel, vqinfo.assigned_to_ops
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid=vqinfo.quoteid AND vqinfo.quotetype = 'group'
                WHERE vq.quoteid='$quoteid';";
    $date_result = mysqli_query($conn, $date_sql);
    $date_row = mysqli_fetch_assoc($date_result);

    if (!$date_row || empty($date_row['date_of_travel']) || $date_row['date_of_travel'] == '0000-00-00') {
        exit();
    }
    $date_of_travel = $date_row['date_of_travel'];
    $quote_number = $date_row['quote_no'];
    $quote_subject = $date_row['subject'];
    $quote_assigned_to_ops = $date_row['assigned_to_ops'] ?? '';

    if(empty($quote_assigned_to_ops)) {
        echo 'Please assign to ops before operating';
        exit();
    }

    $vendor_sql = "SELECT vi.sequence_no, vi.day, vp.productName, vp.vendorid, vv.vendorName, vv.email, vi.cf_928 
                FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vp ON vi.productid=vp.productid
                LEFT JOIN tdu_vendors vv ON vi.vendorid=vv.vendorid
                WHERE vi.id='$quoteid' AND vv.vendorid='$vendorid_index' 
                    AND vi.booking_status='Pending' 
                    AND vp.productName IS NOT NULL 
                    AND vv.vendorName IS NOT NULL;";
    $vendor_result = mysqli_query($conn, $vendor_sql);
    if (!$vendor_result) {
        die("Error fetching vendor details: " . mysqli_error($conn));
    }

    $vendor_data = [];
    while ($vendor_row = mysqli_fetch_assoc($vendor_result)) {
        $vendorid = $vendor_row['vendorid'];
        $vendorName = $vendor_row['vendorName'];
        $vendorEmail = $vendor_row['email'];
        $productName = $vendor_row['productName'];
        $day_offset = (int) $vendor_row['day'] - 1;
        $travel_date = date('d-M-Y', strtotime($date_of_travel . " +$day_offset days"));
        $sequence_no = $vendor_row['sequence_no'];
        $cf_928 = $vendor_row['cf_928'];

        $itinerary_sql = "SELECT t.quoteid, t.sequence_no, t.meta_key, t.meta_value
                        FROM vtiger_itinerary t
                        JOIN (
                            SELECT quoteid, sequence_no, meta_key, MAX(created_at) AS max_created_at
                            FROM vtiger_itinerary
                            WHERE quoteid = '$quoteid' 
                                AND sequence_no = '$sequence_no'
                                AND meta_key IN ('tourtime', 'pickup_location', 'dropoff_location', 'adults', 'children', 'check_in', 'check_out', 'single_rooms', 'double_rooms', 'triple_rooms')
                            GROUP BY quoteid, sequence_no, meta_key
                        ) latest 
                        ON t.quoteid = latest.quoteid 
                        AND t.sequence_no = latest.sequence_no
                        AND t.meta_key = latest.meta_key
                        AND t.created_at = latest.max_created_at;";
        $itinerary_result = mysqli_query($conn, $itinerary_sql);

        $pickup_time = '';
        $pickup_location = '';
        $dropoff_location = '';
        $adults = '';
        $children = '';
        $check_in = '';
        $check_out = '';
        $single_rooms = '';
        $double_rooms = '';
        $triple_rooms = '';

        while ($itinerary_row = mysqli_fetch_assoc($itinerary_result)) {
            switch ($itinerary_row['meta_key']) {
                case 'tourtime':
                    $pickup_time = $itinerary_row['meta_value'];
                    break;
                case 'pickup_location':
                    $pickup_location = $itinerary_row['meta_value'];
                    break;
                case 'dropoff_location':
                    $dropoff_location = $itinerary_row['meta_value'];
                    break;
                case 'adults':
                    $adults = (int) $itinerary_row['meta_value'];
                    break;
                case 'children':
                    $children = (int) $itinerary_row['meta_value'];
                    break;
                case 'check_in':
                    $check_in = $itinerary_row['meta_value'];
                    break;
                case 'check_out':
                    $check_out = $itinerary_row['meta_value'];
                    break;
                case 'single_rooms':
                    $single_rooms = $itinerary_row['meta_value'];
                    break;
                case 'double_rooms':
                    $double_rooms = $itinerary_row['meta_value'];
                    break;
                case 'triple_rooms':
                    $triple_rooms = $itinerary_row['meta_value'];
                    break;
            }
        }

        $pax_details_incomplete = false;
        $pax_sql = "SELECT surname, given_name, phone_code, phone FROM vtiger_pax_in_hotel WHERE quoteid = '$quoteid'";
        $pax_result = mysqli_query($conn, $pax_sql);
        $pax_details = "<table border='1'>";
        if(mysqli_num_rows($pax_result) > 0) {
            $pax_details .= "<tr><td>Name</td><td>Phone</td></tr>";
        }
        while ($pax_row = mysqli_fetch_assoc($pax_result)) {
            $fullPhone = $pax_row['phone_code'] . ' ' . $pax_row['phone'];
            $pax_details .= "<tr><td>" . $pax_row['given_name'] . " " . $pax_row['surname'] . "</td><td>" . $fullPhone . "</td></tr>";
            if(empty($fullPhone) || empty($pax_row['given_name']) || empty($pax_row['surname'])) {
                $pax_details_incomplete = true;
                break;
            }
        }
        $pax_details .= "</table>";
        if(mysqli_num_rows($pax_result) == 0 || $pax_details_incomplete) {
            $pax_details = "";
        }

        $flight_sql = "SELECT flight_number, from_city, from_datetime, to_city, to_datetime
                       FROM tdu_flight_details
                       WHERE quoteid = '$quoteid' AND sequence_no = '$sequence_no'
                       ORDER BY created_at DESC LIMIT 1;";
        $flight_result = mysqli_query($conn, $flight_sql);
        $flight_details = "";
        if ($flight_row = mysqli_fetch_assoc($flight_result)) {
            $flight_details = "<p>Flight Number: " . $flight_row['flight_number'] . "</p>";
            $flight_details .= "<p>Flight Details: " . $flight_row['from_city'] . " " . $flight_row['from_datetime'] . " -> ";
            $flight_details .= $flight_row['to_city'] . " " . $flight_row['to_datetime'] . "</p>";
        }

        if (!isset($vendor_data[$vendorid])) {
            $vendor_data[$vendorid] = [
                'vendorName' => $vendorName,
                'email' => $vendorEmail,
                'products' => [],
            ];
        }

        $vendor_data[$vendorid]['products'][] = [
            'name' => $productName,
            'dates' => $travel_date,
            'flight_details' => $flight_details,
            'pickup_time' => $pickup_time,
            'pickup_location' => $pickup_location,
            'dropoff_location' => $dropoff_location,
            'check_in' => $check_in,
            'check_out' => $check_out,
            'single_rooms' => $single_rooms,
            'double_rooms' => $double_rooms,
            'triple_rooms' => $triple_rooms,
            'pax_details' => $pax_details,
            'adults' => $adults,
            'children' => $children,
            'cf_928' => $cf_928
        ];
    }

    foreach ($vendor_data as $vendorid => $data) {
        $missing_info = false;

        foreach ($data['products'] as $product) {
            if (empty($product['name']) || empty($product['dates']) || 
                ($product['cf_928'] != 'Transfers' && $product['cf_928'] != 'Hotel' && empty($product['pickup_time'])) || 
                ($product['cf_928'] == 'Hotel' && (empty($product['check_in']) || empty($product['check_out']) || empty($product['pax_details']))) || 
                ($product['cf_928'] == 'Transfers' && (empty($product['pickup_time']) || empty($product['pickup_location']) || empty($product['dropoff_location'])))) {
                
                $missing_info = true;
                break;
            }
        }

        if ($missing_info) {
            echo 'Operation Details are INCOMPLETE';
            break;
        } else {
            $email_body = "<p>Dear Team,</p><br>";
            $email_body .= "<p>Please find below the booking request:</p><br>";

            $hasHotel = false;

            foreach ($data['products'] as $product) {
                $email_body .= "<p><strong>" . $product['name'] . "</strong></p>";

                if ($product['cf_928'] == 'Hotel') {
                    $hasHotel = true;

                    $email_body .= "<p>Checkin: " . date("d-M-Y", strtotime($product['check_in'])) . "</p>";
                    $email_body .= "<p>Checkout: " . date("d-M-Y", strtotime($product['check_out'])) . "</p>";

                    if ((int)$product['single_rooms'] > 0) {
                        $email_body .= "<p>Single Rooms: " . $product['single_rooms'] . "</p>";
                    }
                    if ((int)$product['double_rooms'] > 0) {
                        $email_body .= "<p>Double Rooms: " . $product['double_rooms'] . "</p>";
                    }
                    if ((int)$product['triple_rooms'] > 0) {
                        $email_body .= "<p>Triple Rooms: " . $product['triple_rooms'] . "</p>";
                    }
                } else if ($product['cf_928'] == 'Transfers') {
                    $email_body .= "<p>Date: " . $product['dates'] . "</p>";
                    $email_body .= "<p>Pickup time: " . $product['pickup_time'] . "</p>";
                    $email_body .= "<p>Pickup location: " . $product['pickup_location'] . "</p>";
                    $email_body .= "<p>Drop off location: " . $product['dropoff_location'] . "</p>";
                    $email_body .= $product['flight_details'];
                } else {
                    $email_body .= "<p>Date: " . $product['dates'] . "</p>";
                    $email_body .= "<p>Time: " . $product['pickup_time'] . "</p>";
                }

                $email_body .= "<br>";
            }

            $email_body .= "<p>Number of Passengers: " . $product['adults'] . " adults, " . $product['children'] . " children</p>";

            if ($hasHotel && !empty($product['pax_details'])) {
                $email_body .= "<br><p>Request to please confirm the above with breakfast</p>";

                $email_body .= "<br><p>Passenger Details:</p>";
                $email_body .= $product['pax_details'];
            }

            echo $email_body;
        }
    }
}
?>
