<?php
include "dbconn.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $vendorId = isset($data['vendorId']) ? intval($data['vendorId']) : 0;
    $preferred = isset($data['preferred']) ? intval($data['preferred']) : null;

    if ($vendorId > 0 && ($preferred === 0 || $preferred === 1)) {
        $stmt = $conn->prepare("UPDATE tdu_vendors SET preferred = ? WHERE vendorid = ?");
        $stmt->bind_param('ii', $preferred, $vendorId);

        if ($stmt->execute()) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Failed to update preferred status']);
        }

        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid input data']);
    }

    $conn->close();
}
?>
