<?php
// hotel rooming list / visa pax list upload + download

include "dbconn.php";
session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}

if (isset($_POST['upload'])) {
    // Handle uploading visa pax CSV file
    $quote_id = $_POST['quoteid'];
    $quote_number = $_POST['quoteNumber'];

    // Check if a file was uploaded
    if (isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] === 0) {
        // Create visa_pax_list_csv folder if it does not exist
        if (!is_dir('visa_pax_list_csv')) {
            mkdir('visa_pax_list_csv', 0777, true);
        }

        $file_tmp = $_FILES['csv_file']['tmp_name'];
        $original_file_name = basename($_FILES['csv_file']['name']);
        $current_time = date('Ymd_His');
        $new_file_name = $quote_number . '_visa_' . $current_time . '.csv';
        $destination = 'visa_pax_list_csv/' . $new_file_name;

        // Move uploaded file to visa_pax_list_csv folder
        if (move_uploaded_file($file_tmp, $destination)) {
            // Save file path into vtiger_quotes
            $escaped_path = $conn->real_escape_string($destination);
            $sql = "UPDATE vtiger_quotes SET visa_pax_path = '$escaped_path' WHERE quoteid = '$quote_id';";

            if ($conn->query($sql)) {
                header('Location: quote.php?opt=summary&quoteNumber=' . $quote_number . '&edit=doc');
                exit();
            } else {
                echo "Database update error: " . $conn->error;
            }
        } else {
            echo "Failed to move uploaded file.";
        }
    } else {
        echo "Error uploading the file.";
    }
}

else if (isset($_POST['download'])) {
    // Handle downloading visa pax CSV file
    $quote_id = $_POST['quoteid'];
    $quote_number = $_POST['quoteNumber'];

    $sql = "SELECT given_name, surname FROM vtiger_pax_in_hotel WHERE quoteid = '$quote_id';";
    $result = $conn->query($sql);

    $current_time = date('Y-m-d-H-i-s');
    $filename = "{$quote_number}-visa-{$current_time}.csv";

    header('Content-Type: text/csv');
    header("Content-Disposition: attachment; filename=\"{$filename}\"");
    header('Pragma: no-cache');
    header('Expires: 0');

    $output = fopen('php://output', 'w');

    // CSV headers
    fputcsv($output, ['First Name As Per Passport', 'Last Name As Per Passport', 'Passport Number', 'Gender (M/F)']);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            fputcsv($output, [
                $row['given_name'],
                $row['surname'],
                '',
                ''
            ]);
        }
    }

    fclose($output);
    exit();
}
?>
