<?php
// api_get_supplier_transactions.php
// This API endpoint fetches BOTH QBO transaction history AND Vtiger quote details.
// FIX: Replaced PHP 7.4+ arrow function with a standard anonymous function for better compatibility.

header('Content-Type: application/json');

require_once __DIR__ . '/dbconn.php';
require_once __DIR__ . '/qbo_bootstrap.php';
global $conn, $qboUtil;

$vendor_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$vendor_name = $_GET['name'] ?? null;
$date_from = $_GET['from'] ?? date('Y-m-d', strtotime('-90 days'));
$date_to = $_GET['to'] ?? date('Y-m-d');

$response = [
    'transaction_history' => [],
    'quote_details' => []
];

if (!$vendor_name) {
    http_response_code(400);
    $response['error'] = 'Missing Vendor Name.';
    echo json_encode($response);
    exit;
}

try {
    if ($qboUtil) {
        $qboVendor = $qboUtil->findEntityByFuzzyName('Vendor', $vendor_name);
        
        if ($qboVendor) {
            $vendorId = $qboVendor->Id;
            $all_transactions = [];
            $bill_id_to_class_map = [];
            $class_ids_from_txns = [];
            $all_bills = [];

            $startPosition = 1;
            while(true) {
                $bill_query = "SELECT * FROM Bill WHERE VendorRef = '{$vendorId}' AND TxnDate >= '{$date_from}' AND TxnDate <= '{$date_to}' STARTPOSITION {$startPosition} MAXRESULTS 1000";
                $billsBatch = $qboUtil->getDataService()->Query($bill_query);
                if (empty($billsBatch)) break;
                
                foreach ($billsBatch as $bill) {
                    $all_bills[] = $bill;
                    $lines = is_array($bill->Line) ? $bill->Line : [$bill->Line];
                    foreach ($lines as $line) {
                        if (isset($line->ItemBasedExpenseLineDetail->ClassRef)) {
                            $classRef = $line->ItemBasedExpenseLineDetail->ClassRef;
                            $bill_id_to_class_map[$bill->Id] = $classRef;
                            $class_ids_from_txns[] = $classRef;
                            break; 
                        }
                    }
                }
                if (count($billsBatch) < 1000) break;
                $startPosition += 1000;
            }

            $startPosition = 1;
            $all_payments = [];
            while(true) {
                $payment_query = "SELECT * FROM BillPayment WHERE VendorRef = '{$vendorId}' AND TxnDate >= '{$date_from}' AND TxnDate <= '{$date_to}' STARTPOSITION {$startPosition} MAXRESULTS 1000";
                $paymentsBatch = $qboUtil->getDataService()->Query($payment_query);
                if (empty($paymentsBatch)) break;
                $all_payments = array_merge($all_payments, $paymentsBatch);
                if (count($paymentsBatch) < 1000) break;
                $startPosition += 1000;
            }

            $unique_class_ids = array_unique(array_filter($class_ids_from_txns));
            $class_id_to_name_map = [];
            if (!empty($unique_class_ids)) {
                $id_list_string = "'" . implode("','", $unique_class_ids) . "'";
                $class_query = "SELECT Id, Name FROM Class WHERE Id IN ({$id_list_string})";
                $qbo_classes = $qboUtil->getDataService()->Query($class_query);
                foreach($qbo_classes as $class) {
                    $class_id_to_name_map[$class->Id] = $class->Name;
                }
            }
            
            foreach ($all_bills as $bill) {
                $class_id = $bill_id_to_class_map[$bill->Id] ?? null;
                $quote_no = $class_id ? ($class_id_to_name_map[$class_id] ?? null) : null;
                $all_transactions[] = ['type' => 'Bill', 'date' => $bill->TxnDate, 'doc_num' => $bill->DocNumber, 'amount' => $bill->TotalAmt, 'quote_no' => $quote_no];
            }
            
            foreach($all_payments as $payment) {
                if (empty($payment->Line)) continue;
                $payment_lines = is_array($payment->Line) ? $payment->Line : [$payment->Line];
                foreach ($payment_lines as $line) {
                    $linkedTxns = isset($line->LinkedTxn) ? (is_array($line->LinkedTxn) ? $line->LinkedTxn : [$line->LinkedTxn]) : [];
                    foreach ($linkedTxns as $linkedTxn) {
                        if (isset($linkedTxn->TxnId) && $linkedTxn->TxnType === 'Bill') {
                            $linkedBillId = $linkedTxn->TxnId;
                            $class_id = $bill_id_to_class_map[$linkedBillId] ?? null;
                            $quote_no = $class_id ? ($class_id_to_name_map[$class_id] ?? null) : null;
                            $all_transactions[] = ['type' => 'Bill Payment', 'date' => $payment->TxnDate, 'doc_num' => $payment->DocNumber, 'amount' => $line->Amount, 'quote_no' => $quote_no];
                        }
                    }
                }
            }
            
            // --- THE CHANGE IS HERE ---
            // Replaced arrow function with standard anonymous function for compatibility.
            usort($all_transactions, function($a, $b) {
                return strtotime($b['date']) <=> strtotime($a['date']);
            });

            $response['transaction_history'] = $all_transactions;
        }
    }

    if ($vendor_id > 0) {
        $sql_params = [$vendor_id, $date_from, $date_to];
        $sql_types = "iss";
        $sql = "SELECT DISTINCT q.quote_no, q.subject, q.quotestage, qcf.cf_1162 AS travel_date, (q.adults + q.children) AS pax FROM tdu_vendors v JOIN tdu_products p ON v.vendorid = p.vendorid JOIN vtiger_inventoryproductrel i ON p.productid = i.productid JOIN vtiger_quotes q ON i.id = q.quoteid JOIN vtiger_quotescf qcf ON q.quoteid = qcf.quoteid WHERE v.vendorid = ? AND qcf.cf_1162 BETWEEN ? AND ? ORDER BY qcf.cf_1162 DESC";
        $stmt = $conn->prepare($sql);
        if ($stmt) { $stmt->bind_param($sql_types, ...$sql_params); $stmt->execute(); $response['quote_details'] = $stmt->get_result()->fetch_all(MYSQLI_ASSOC); $stmt->close(); }
    }

} catch (Exception $e) {
    http_response_code(500);
    $response['error'] = 'API Error: ' . $e->getMessage();
}

echo json_encode($response);