<?php
require_once __DIR__ . "/../ai_keys.php";
require_once "file_extract_functions.php";

function ai_confirmationExtract($conversationID, $conn)
{
    if (empty($conversationID) || !$conn) return NULL;
    $messageData;
    $conversationID_safe = mysqli_real_escape_string($conn, $conversationID);
    $sql = "SELECT e.subject, e.plaintext_body, e.full_body, e.sender, a.attachment_id, a.file_name, a.message_id as messageID, e.msgid
            FROM tdu_emails e
            LEFT JOIN tdu_attachments a ON e.message_id = a.message_id
            WHERE conversation_id = '$conversationID_safe'
            ORDER BY received_datetime DESC";

    // 2. Initialize an array to hold all the results
    $allMessagesData = []; // Use an array to store multiple rows
    
    // 3. Execute the query
    $result = mysqli_query($conn, $sql);
    
    // 4. Check for query errors first
    if (!$result) {
        error_log("DB Error fetching messages for Conv ID $conversationID_safe: " . mysqli_error($conn));
        // Depending on context, you might want to return or throw an exception here
        // For now, we'll let it proceed, $allMessagesData will remain empty
    } else {
        // 5. Check if there are any rows returned (optional but good practice)
        if (mysqli_num_rows($result) > 0) {
            // 6. Loop through all rows in the result set
            while ($row = mysqli_fetch_assoc($result)) {
                // 7. Add the current row (as an associative array) to our results array
                $allMessagesData[] = $row;
            }
        }
        // 8. Free the result set memory
        mysqli_free_result($result);
    }
    $messageData = $allMessagesData[0];
    $allAttachments = [];
    $extractedText = [];
    foreach($allMessagesData as $message)
    {
        if($message['file_name'])
        {
            $allAttachments[] = $message;
    
    $endpoint = "https://dev.yourbestwayhome.com.au/turtledownunder/ajax_outlook_attachment_download.php?attachment_id=".urlencode($message['attachment_id'])."&message_id=".urlencode($message['msgid'])."&file_name=".urlencode($message['file_name']);
    $url = $endpoint;

    // 1. Initialize cURL session
    $ch = curl_init();
    
    // 2. Set options
    curl_setopt($ch, CURLOPT_URL, $url); // Set the URL
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the response as a string instead of outputting it
    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout in seconds
    // Optional: Add headers, user agent, etc.
    // curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Authorization: Bearer YOUR_TOKEN'));
    // curl_setopt($ch, CURLOPT_USERAGENT, 'My PH P Script');
    
    // 3. Execute the request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get HTTP status code
    
    // 4. Check for errors
    if (curl_errno($ch)) {
        $error_msg = curl_error($ch);
         echo "cURL Error: " . $error_msg;
    } else {
         if ($httpCode == 200) {
             // Success! Process the response (often JSON)
            $fileType = getFileTypeFromString($response);
            if($fileType == "PDF Document"){$extractedText[] = extractTextFromPDF($response);}
            else if($fileType == "Word Document (Modern Format - DOCX)"){$extractedText[] = extractTextfromWordDoc($response);}
            else{/*return $fileType." Detected, Could not extract";*/}
         } else {
              echo "HTTP Error: " . $httpCode;
              echo "\nResponse:\n" . $response;
         }
    }
        }
    }
    //return $allAttachments[3]['file_name'];
    //return $allMessagesData[8]['file_name'];
    //return $messageData;
    //return $extractedText;
    $AI_response = findConfirmationNumber($messageData['subject'], $messageData['full_body'], implode("\n\n---\n\n", $extractedText));
    // 5. Close cURL session
    curl_close($ch);
    
    return $AI_response;
    

}

function findConfirmationNumber($email_subject = "", $email_body, $attachment_text = ""): array
{
    //var_dump($attachment_text);
    // Combine all text sources for the prompt
    //$attachment_text = extractTextFromPDF($attachment_text);
    $full_email_content = trim($email_subject . "\n\n" . $email_body . "\n\n" . $attachment_text);
    
    // --- Initial Input Validation ---
    if (empty(trim($full_email_content))) {
        error_log("findConfirmationNumber: Combined email subject, body, and attachment text are empty.");
        return [
            'confirmationNumber' => 'N/A',
            'time'               => 'N/A',
            'description'        => 'N/A'
        ];
    }

    // --- AI Prompt Definition ---
    // Instructing the AI to *only* output the specific string format is crucial.
    $preprompt =   "Analyze the following email content and extract the primary confirmation number (often called booking number, order number, or similar), the tour start time/date, and a description (like 'Penguin Parade - Standard Viewing Entry Ticket', 'Flight Booking QF123', 'Order #12345 Items', 'Hotel Reservation').
                    Format the output STRICTLY and ONLY as a single string exactly like this: ('confirmationNumber_value', 'time_value', 'description_value').
                    Use 'N/A' (as a string within the quotes) for any value you cannot confidently determine.
                    YOUR ENTIRE RESPONSE MUST FOLLOW THIS FORMAT.
                    DO NOT include any other text, explanations, apologies, markdown, lists, or line breaks before or after the required single-line string.
                    DO NOT use double quotes; use only single quotes as shown.
                    DO NOT add unnecessary whitespace; use only single spaces if needed between elements.
                    Remember to include as much details as possible in the description, especially the pickup address.
                    Remember numbers with TDU is the last resort as the confirmation number.
                    Example 1: ('BOOKING-XYZ789', '2024-07-15 14:30', 'Flight Booking QF123')
                    Example 2: ('987654321', 'N/A', 'Online Order - Electronics')
                    Example 3: ('N/A', 'N/A', 'Newsletter Subscription')
    Email Content:
    ";
    $prompt_for_ai = $preprompt . $full_email_content;
    $prompt_for_ai_utf8 = $prompt_for_ai;
    if (!mb_check_encoding($prompt_for_ai, 'UTF-8')) {
        error_log("findConfirmationNumber: Detected non-UTF-8 characters in the combined prompt text. Attempting conversion...");
        // Attempt conversion from common encodings
        $converted = mb_convert_encoding($prompt_for_ai, 'UTF-8', 'UTF-8, Windows-1252, ISO-8859-1');

        if ($converted === false) {
            // Conversion failed - this indicates seriously garbled data
            error_log("findConfirmationNumber Error: Failed to convert prompt text to UTF-8. The source encoding might be unknown or the data corrupted.");
            // You might want to return an error here, as the data is unusable for JSON
            return ['error' => 'Data encoding error: Could not convert input text to UTF-8 for API request.'];
        }
        // Use the successfully converted string
        $prompt_for_ai_utf8 = $converted;
        error_log("findConfirmationNumber: Successfully converted prompt text to UTF-8.");
    }
    
    $apiUrl = apiURL_Flash();
    $payload = [
        'contents' => [
            [
                'parts' => [
                    // Ensure the entire prompt goes here
                    ['text' => $prompt_for_ai_utf8]
                ]
            ]
        ],
        'generationConfig' => [
            'temperature'       => 0.2, // Lower temperature for more deterministic output based on instructions
            'maxOutputTokens'   => 256, // Limit output size, should be enough for the requested format
            'topP'              => 0.95,
            'topK'              => 40
           // Consider adding 'response_mime_type' => 'text/plain' if available and needed
        ]
        // Optional: Add safetySettings if needed
        // 'safetySettings' => [ ... ]
    ];

    $headers = [
        'Content-Type: application/json', // Correct Content-Type for JSON payload
    ];
    //var_dump("test: ".$apiUrl);
    // --- Execute cURL Request ---
    $ch = curl_init($apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload)); // Encode payload as JSON
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20); // Connection timeout
    curl_setopt($ch, CURLOPT_TIMEOUT, 90);       // Total execution timeout

    $response_body = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);

    // --- Handle cURL/HTTP Errors ---
    if ($curlError) {
        error_log("findConfirmationNumber: cURL Error - " . $curlError);
        return ['error' => 'API communication error (cURL).'];
    }

    if ($httpCode !== 200) {
        error_log("findConfirmationNumber: API Error - HTTP Status $httpCode. Response: " . $response_body);
        // Try to decode the error response from Gemini for more details
        $errorDetails = json_decode($response_body, true);
        $errorMessage = $errorDetails['error']['message'] ?? 'Unknown API error';
        return ['error' => "API error ($httpCode): $errorMessage"];
    }

    // --- Process Successful API Response ---
    $responseData = json_decode($response_body, true);

    // Extract the generated text - check structure carefully based on Gemini API V1beta response format
    $generated_text = $responseData['candidates'][0]['content']['parts'][0]['text'] ?? null;

    if ($generated_text === null) {
        error_log("findConfirmationNumber: Could not extract generated text from API response. Response: " . $response_body);
        // Fallback to N/A if text structure is unexpected
         return [
            'confirmationNumber' => 'N/A',
            'time'               => 'N/A',
            'description'        => 'N/A'
        ];
    }

     // Trim whitespace AND remove potential UTF-8 BOM
    $trimmed_text = trim($generated_text);

    // --- FIX: Explicitly remove potential BOM ---
    $bom = "\xEF\xBB\xBF";
    if (strpos($trimmed_text, $bom) === 0) { // Check if BOM is exactly at the beginning
        $trimmed_text = substr($trimmed_text, 3); // Remove the 3-byte BOM
        error_log("findConfirmationNumber: Removed BOM from AI response."); // Log if BOM was found
    }
    // --- End FIX ---

    // --- Parse the AI's String Output ---
    // Regex to capture the content within ('value1', 'value2', 'value3')
    // It handles potential whitespace around commas and quotes.
    $pattern = "/^\(\s*'((?:\\.|[^'])*)'\s*,\s*'((?:\\.|[^'])*)'\s*,\s*'((?:\\.|[^'])*)'\s*\)$/u";
    $matches = [];
    
    // Ensure the cleaned text isn't empty before matching
    if (empty($trimmed_text)) {
         error_log("findConfirmationNumber: AI response was empty after cleaning.");
         return [
            'confirmationNumber' => 'N/A: AI response empty after cleaning.',
            'time'               => 'N/A: AI response empty after cleaning.',
            'description'        => 'N/A: AI response empty after cleaning.'
         ];
    }
    
    if (preg_match($pattern, $trimmed_text, $matches)) {
        // Successfully parsed the expected format
        // $matches[0] is the full string, $matches[1], $matches[2], $matches[3] are the captured groups
        return [
            // We might want to remove the backslashes from the final output if they aren't desired
            'confirmationNumber' => stripslashes($matches[1]),
            'time'               => stripslashes($matches[2]),
            'description'        => stripslashes($matches[3]) // Use stripslashes() to remove the escaping backslash
        ];
    } else {
        // The AI did not return the string in the expected format

        // --- DETAILED LOGGING ---
        $logMessage = "findConfirmationNumber: Failed to parse AI response.\n";
        $logMessage .= "Expected format: ('val1', 'val2', 'val3')\n";
        $logMessage .= "Received String (len=" . strlen($trimmed_text) . "): [" . $trimmed_text . "]\n"; // Brackets help see leading/trailing whitespace
        $logMessage .= "Received Hex: " . bin2hex($trimmed_text) . "\n";
        // Also log the raw response before trimming, in case trim is the issue
        $logMessage .= "Raw String Before Trim (len=" . strlen($generated_text) . "): [" . $generated_text . "]\n";
        $logMessage .= "Raw Hex Before Trim: " . bin2hex($generated_text);
        error_log($logMessage);
        // --- END DETAILED LOGGING ---
        return [
            'confirmationNumber' => 'N/A: ' . $parseFailReason,
            'time'               => 'N/A: ' . $parseFailReason,
            'description'        => 'N/A: ' . $parseFailReason
        ];
    }
}
?>