<?php
header('Location: quote.php');
exit;

include 'dbconn.php';

// First SQL query
$sql1 = "
    SELECT vq.quoteid, vq.quote_no, vq.quotestage, va.accountname, vqinfo.assigned_to_region, 
           vqinfo.assigned_to_sales_agent, vqinfo.assigned_to_external_sales_agent, 
           vqinfo.travel_agent_contact_name, vqinfo.office_phone, vqinfo.mobile_phone, 
           vqinfo.email 
    FROM (
        SELECT * 
        FROM vtiger_quotes 
        WHERE quoteid = (
            SELECT MIN(quoteid) AS quoteid 
            FROM vtiger_quotes AS sub 
            WHERE sub.quote_no = vtiger_quotes.quote_no
        ) 
        ORDER BY quote_no DESC
    ) vq 
    LEFT JOIN vtiger_account va ON vq.accountid = va.accountid
    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid 
    AND vqinfo.quotetype='group';
";

$result1 = mysqli_query($conn, $sql1);

if (!$result1) {
    die('Error: ' . mysqli_error($conn));
}

// Save first query results to CSV
$filename1 = "quotes_group_export_" . date('Ymd') . ".csv";

// Open output stream for writing to the first CSV
$output1 = fopen($filename1, 'w');

// Write column headers for the first CSV
fputcsv($output1, array(
    'Quote ID', 
    'Quote No', 
    'Quote Stage', 
    'Organization',
    'Assigned Region', 
    'Assigned Sales Agent', 
    'Assigned External Sales Agent', 
    'Travel Agent Contact', 
    'Office Phone', 
    'Mobile Phone', 
    'Email'
));

// Fetch each row from the result set and write to CSV
while ($row = mysqli_fetch_assoc($result1)) {
    fputcsv($output1, $row);
}

// Close the file handle for the first CSV
fclose($output1);

// Second SQL query
$sql2 = "
    SELECT vq.quoteid, vq.quote_no, vq.subject, vq.quotestage, va.accountname,
           vqinfo.assigned_to_region, vqinfo.assigned_to_sales_agent, 
           vqinfo.assigned_to_external_sales_agent, vqinfo.travel_agent_contact_name, 
           vqinfo.office_phone, vqinfo.mobile_phone, vqinfo.email  
    FROM vtiger_quotes_crm vq
    LEFT JOIN vtiger_account va ON vq.accountid = va.accountid
    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype='fit'
    LEFT JOIN vtiger_quotescf_crm vc ON vq.quoteid = vc.quoteid
    WHERE vc.cf_1162 >= '2024-10-01';
";

$result2 = mysqli_query($conn, $sql2);

if (!$result2) {
    die('Error: ' . mysqli_error($conn));
}

// Save second query results to CSV
$filename2 = "quotes_fit_export_" . date('Ymd') . ".csv";

// Open output stream for writing to the second CSV
$output2 = fopen($filename2, 'w');

// Write column headers for the second CSV
fputcsv($output2, array(
    'Quote ID', 
    'Quote No', 
    'Subject', 
    'Quote Stage', 
    'Organization',
    'Assigned Region', 
    'Assigned Sales Agent', 
    'Assigned External Sales Agent', 
    'Travel Agent Contact', 
    'Office Phone', 
    'Mobile Phone', 
    'Email'
));

// Fetch each row from the result set and write to CSV
while ($row = mysqli_fetch_assoc($result2)) {
    fputcsv($output2, $row);
}

// Close the file handle for the second CSV
fclose($output2);

// Optionally, you could create a ZIP archive for both files
$zip = new ZipArchive();
$zipFilename = "quotes_exports_" . date('Ymd') . ".zip";

if ($zip->open($zipFilename, ZipArchive::CREATE) !== TRUE) {
    die("Could not create ZIP file.");
}

// Add the CSV files to the ZIP archive
$zip->addFile($filename1);
$zip->addFile($filename2);

// Close the ZIP file
$zip->close();

// Serve the ZIP file for download
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $zipFilename . '"');
header('Content-Length: ' . filesize($zipFilename));

// Output the ZIP file
readfile($zipFilename);

// Clean up - remove the CSV and ZIP files from the server
unlink($filename1);
unlink($filename2);
unlink($zipFilename);

// Close the database connection
mysqli_close($conn);

exit;
?>
