<?php
session_start();
$is_logged_in = isset($_SESSION['user_name']) && $_SESSION['user_name'] != '';
$title = $_SESSION['title'] ?? '';
$department = $_SESSION['department'] ?? '';

// Define the base path
$base_path = '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <title>TDU Dashboard</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            background-color: #334155;
            border-bottom: 2px solid #e7e7e7;
        }
        
        .logo {
            flex: 2;
        }
        
        .logo img {
            height: 50px;
        }
        
        nav {
            flex: 10;
            display: flex;
            justify-content: left;
            align-items: center;
        }
        
        nav ul {
            list-style: none;
            display: flex;
            padding: 0;
            justify-content: space-between;
        }
        
        nav ul li {
            margin: auto;
            position: relative;
        }
        
        nav ul li a {
            text-decoration: none;
            color: white;
            font-size: 18px;
            padding: 10px 50px;
            display: block;
        }
        
        nav ul li ul {
            position: absolute;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            display: none;
            background-color: #334155;
            list-style: none;
            padding: 10px 0;
            z-index: 1000;
            white-space: nowrap;
        }
        
        nav ul li:hover ul {
            display: block;
        }
        
        nav ul li ul li {
            display: block;
            margin: 0;
        }
        
        nav ul li ul li button {
            display: block;
            width: 100%;
            background-color: transparent;
            color: white;
            border: none;
            padding: 20px 50px;
            cursor: pointer;
            font-size: 16px;
            text-align: center;
        }
        
        nav ul li ul li button:hover {
            background-color: #ffbb00;
            color: black;
        }
        
        .auth {
            flex: 1;
            text-align: right;
        }
        
        .auth a {
            text-decoration: none;
            color: white;
            font-size: 18px;
            margin-left: 15px;
        }
    </style>
</head>
<body>

<header>
    <!-- Logo -->
    <div class="logo">
        <a href="<?php echo $base_path; ?>quote.php"><img src="images/logo.png" alt="TDU"></a>
    </div>

    <!-- Navigation -->
    <nav>
        <ul>
            <?php if ($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'external' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                <li>
                    <a href="#">Quote</a>
                    <ul>
                        <?php if ($title == 'admin' || $title == 'fit' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=search'">View All Quotes</button>
                            </li>
                        <?php } ?>
                        <?php if ($title == 'sales' || $title == 'external') { ?>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=sales-search'">View All Quotes</button>
                            </li>
                        <?php } ?>
                        <?php if ($title == 'admin') { ?>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=sales-search'">View Sale Quotes</button>
                            </li>
                        <?php } ?>
                        <?php if ($title == 'admin' || $title == 'group' || $title == 'fit' || $title == 'sales') { ?>
                            <li class="right-menu">
                                <button type="button">New Group Quotes</button>
                                <ul class="right-menu-sub" style="margin-left: 110%;">
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=create-standard'">New Standard Group Quote</button>
                                    </li>
                                    
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=create-group'">New Pax Range Quote</button>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'fit' || $title == 'group' || $title == 'account') { ?>
                <li>
                    <a href="<?php echo $base_path; ?>quote.php?opt=ops-group">Operation</a>
                </li>
            <?php } ?>
            <?php if (false && ($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'external' || $title == 'qa')) { ?>
                <li>
                    <a href="<?php echo $base_path; ?>quote.php?opt=sales-home">Sales</a>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                <li>
                    <a href="#">Inventory</a>
                    <ul>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=organizations'">Organizations</button>
                        </li>
                        <?php if ($title == 'admin' || $title == 'account') { ?>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=vendors&vendoractive=Yes'">Vendors</button>
                            </li>
                        <?php } ?>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=products-list&active=Yes'">Products</button>
                        </li>
                    </ul>
                </li>
            <?php } ?>
            <?php if (false) { ?>
                <li>
                    <a href="#">AU Vendor</a>
                    <ul>
                        <li class="right-menu">
                            <button type="button">Hotel</button>
                            <ul class="right-menu-sub" style="margin-left: 100%;">
                                <li>
                                    <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=hotel&country=au'">Australia</button>
                                </li>
                                <li>
                                    <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=hotel&country=nz'">New Zealand</button>
                                </li>
                            </ul>
                        </li>
                        <?php if ($title == 'admin' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=vendor&country=au&category=Attraction'">Attraction</button>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=vendor&country=au&category=Restaurant'">Restaurant</button>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=vendor&country=au&category=Transfer'">Transfer</button>
                                <?php if ($title == 'admin') { ?>
                                    <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=add-vendor'">New</button>
                                <?php } ?>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                <li>
                    <a href="#">Online Hotel</a>
                    <ul>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=hotel&country=au'">Australia</button>
                        </li>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=hotel&country=nz'">New Zealand</button>
                        </li>
                    </ul>
                </li>
            <?php } ?>

            <!-- Reports -->
            <?php if ($title == 'admin' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                <li>
                    <a href="#">Report</a>
                    <ul>
                        <?php if ($title == 'admin' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                            <li class="right-menu">
                                <button type="button">Account (BETA)</button>
                                <ul class="right-menu-sub">
                                    <?php if (($title == 'admin' || $title == 'account') && $_SESSION['user_name'] != 'Kunjan') { ?>
                                        <li>
                                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=account'">Account Summary</button>
                                        </li>
                                    <?php } ?>
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-hotel-deadline'">Hotel Payment Deadline</button>
                                    </li>
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=product-deadline'">Product Payment Deadline</button>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>
                        <?php if ($title == 'admin' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                            <li class="right-menu">
                                <button type="button">Operation</button>
                                <ul class="right-menu-sub">
                                    <?php if ($title == 'admin' || $title == 'group') { ?>
                                        <li>
                                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-ops'">Operation Overview (BETA)</button>
                                        </li>
                                        <li>
                                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=booking-products-list'">Products Booking Status</button>
                                        </li>
                                        <li>
                                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=booking-hotels-list'">Hotel Booking</button>
                                        </li>
                                    <?php } ?>
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-payment-deadline'">Group Payment Deadline (BETA)</button>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>
                        <?php if (false && $title == 'admin') { ?>
                            <li class="right-menu">
                                <button type="button">Sales (BETA)</button>
                                <ul class="right-menu-sub">
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=sales-home-admin'">Internal Sales Quote Report</button>
                                    </li>
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=email-tags-monthly'">Internal Sales Tagging Report</button>
                                    </li>
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=sales-home-external'">External Sales</button>
                                    </li>
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-sales'">Sales Overview</button>
                                    </li>
                                    <li>
                                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-sales-region'">Region Report</button>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>
            <?php if (false) { ?>
                <li>
                    <a href="https://gtxsupport.hesk.com/" target="_blank">Help Desk</a>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                <li>
                    <a href="<?php echo $base_path; ?>quote.php?opt=office-email">MailBox</a>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa') { ?>
                <li>
                    <a href="<?php echo $base_path; ?>task.php?opt=tasks">Task</a>
                </li>
            <?php } ?>
        </ul>
    </nav>

    <!-- Login/Logout -->
    <div class="auth">
        <?php if ($is_logged_in): ?>
            <?php if ($title == 'admin') { ?>
                <div class="dropdown">
                    <button class="dropbtn"><i class="fas fa-caret-down"></i></button>
                    <div class="dropdown-content">
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>update_role_admin.php'">Role Admin</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>update_user_role.php'">User Admin</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>./email'">Outlook Admin</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>update_80_agent_payment.php'">80% Agent Payments</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=membership-list'">Tiers Markup</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=templates'">Templates</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=custom-approval'">Custom Products Approval</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>duplicates.php'">Duplicates (BETA)</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>1_potential_org_duplicates.php'">ORG Merge (BETA)</button>
                        <button type="button" onclick="window.location.href='<?php echo $base_path; ?>task.php?opt=define-auto-task'">Auto Task</button>
                    </div>
                </div>
            <?php } ?>
            <span style="color: white;"><?php echo $_SESSION['user_name']; ?></span>
            <a href="<?php echo $base_path; ?>logout.php" title="logout"><i class="fas fa-sign-out-alt"></i></a>
        <?php else: ?>
            <a href="<?php echo $base_path; ?>login.php">login</a>
        <?php endif; ?>
    </div>

    <style>
        .auth {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .dropdown {
            position: relative;
            display: inline-block;
        }
        
        .dropbtn {
            background-color: transparent;
            border: none;
            color: white;
            cursor: pointer;
            font-size: 18px;
            padding: 10px;
        }
        
        .dropdown-content {
            display: none;
            position: absolute;
            background-color: #334155;
            min-width: 200px;
            z-index: 1;
            right: 0;
        }
        
        .dropdown-content button {
            width: 100%;
            background-color: transparent;
            color: white;
            border: none;
            padding: 10px 20px;
            text-align: left;
            cursor: pointer;
        }
        
        .dropdown-content button:hover {
            background-color: #ffbb00;
            color: black;
        }
        
        .dropdown:hover .dropdown-content {
            display: block;
        }
    </style>

    <style>
        .right-menu {
            position: relative;
        }

        .right-menu .right-menu-sub {
            display: none;
            position: absolute;
            top: 0;
            margin-left: 120%;
            background-color: #334155;
            list-style: none;
            padding: 10px 0;
            z-index: 1000;
            white-space: nowrap;
            border: 1px solid #e7e7e7;
        }

        .right-menu:hover ul {
            display: block;
        }

        .right-menu ul li button {
            display: block;
            width: 100%;
            background-color: transparent;
            color: white;
            border: none;
            padding: 20px 50px;
            cursor: pointer;
            font-size: 16px;
        }

        .right-menu ul li button:hover {
            background-color: #ffbb00;
            color: black;
        }
    </style>
</header>

</body>
</html>
