<?php
include "dbconn.php";

date_default_timezone_set('Australia/Melbourne');
$today = date('Y-m-d');

// SQL to get all quoteid and cf_1162 (filtered by date)
$sql_quotes = "SELECT vq.quoteid, vqcf.cf_1162 
               FROM vtiger_quotes vq 
               LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid 
               WHERE vqcf.cf_1162 IS NOT NULL AND vqcf.cf_1162 != '0000-00-00'
               AND vq.quotestage NOT LIKE '%Created%' 
               AND vq.quotestage NOT LIKE '%Rejected%' 
               AND vq.quotestage NOT LIKE '%Requote%'";
$result_quotes = mysqli_query($conn, $sql_quotes);

if (!$result_quotes) {
    die("Query failed: " . mysqli_error($conn));
}

// Process each quote
while ($row = mysqli_fetch_assoc($result_quotes)) {
    $quoteid = $row['quoteid'];
    $cf_1162 = $row['cf_1162'];

    // Call the function to process each quoteid and cf_1162
    processVendorsForQuote($conn, $quoteid, $cf_1162);
}

// Function to retrieve all distinct vendorid for each quoteid
function processVendorsForQuote($conn, $quoteid, $cf_1162) {
    // SQL to get all distinct vendorid for each quoteid
    $sql_supplier = "SELECT DISTINCT vv.vendorid, vi.cf_928
                     FROM (SELECT * FROM vtiger_quotes WHERE quoteid='$quoteid') vq
                     LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid = vi.id
                     LEFT JOIN (SELECT * FROM vtiger_products UNION ALL SELECT * FROM vtiger_products_custom) vp ON vi.productid = vp.productid
                     LEFT JOIN (SELECT * FROM vtiger_vendor UNION SELECT * FROM vtiger_vendor_custom) vv ON vi.vendorid = vv.vendorid
                     ORDER BY vv.vendorname, vi.sequence_no ASC;";
    $result_supplier = mysqli_query($conn, $sql_supplier);

    if (!$result_supplier) {
        die("Query failed: " . mysqli_error($conn));
    }

    // Process each vendor
    while ($vendor_row = mysqli_fetch_assoc($result_supplier)) {
        $vendorid = $vendor_row['vendorid'];
        $cf_928 = $vendor_row['cf_928'];

        // Check and handle payment records for each vendor
        checkAndInsertOrUpdatePayment($conn, $quoteid, $vendorid, $cf_1162, $cf_928);
    }
}

function getFirstMondayOrThursdayBefore($cf_1162, $cf_928) {
    // Convert cf_1162 to a DateTime object
    $cf_1162_date = new DateTime($cf_1162);

    if($cf_928 == 'Hotel') {
        $cf_1162_date->modify('-35 days');
    }
    else {
        $cf_1162_date->modify('-7 days');
    }
    
    // Get the day of the week for cf_1162 (1 for Monday through 7 for Sunday)
    $day_of_week = $cf_1162_date->format('N');

    if (in_array($day_of_week, [2, 3, 4])) { 
        // If cf_1162 is Tuesday, Wednesday, or Thursday, go to the previous Monday
        $first_monday_or_thursday = $cf_1162_date->modify('last Monday')->format('Y-m-d');
    } else {
        // If cf_1162 is Friday, Saturday, Sunday, or Monday, go to the previous Thursday
        $first_monday_or_thursday = $cf_1162_date->modify('last Thursday')->format('Y-m-d');
    }

    return $first_monday_or_thursday;
}

// Function to insert or update vtiger_supplier_payment
function checkAndInsertOrUpdatePayment($conn, $quoteid, $vendorid, $cf_1162, $cf_928) {
    $first_monday_or_thursday = getFirstMondayOrThursdayBefore($cf_1162, $cf_928);

    // Check if the record exists
    $sql_check = "SELECT * FROM vtiger_supplier_payment WHERE quoteid='$quoteid' AND vendorid='$vendorid'";
    $result_check = mysqli_query($conn, $sql_check);

    if (!$result_check) {
        die("Query failed: " . mysqli_error($conn));
    }

    if (mysqli_num_rows($result_check) == 0) {
        // Insert new record if it does not exist
        $sql_insert = "INSERT INTO vtiger_supplier_payment (quoteid, vendorid, payment_deadline) 
                       VALUES ('$quoteid', '$vendorid', '$first_monday_or_thursday')";
        mysqli_query($conn, $sql_insert) or die("Insert failed: " . mysqli_error($conn));
        echo $sql_insert . '<br>';
    } else {
        // Update existing record if payment_deadline is null or '0000-00-00'
        $row = mysqli_fetch_assoc($result_check);
        if (true || !isset($row['payment_deadline']) || $row['payment_deadline'] == '0000-00-00') {
            $sql_update = "UPDATE vtiger_supplier_payment 
                           SET payment_deadline='$first_monday_or_thursday' 
                           WHERE quoteid='$quoteid' AND vendorid='$vendorid'";
            mysqli_query($conn, $sql_update) or die("Update failed: " . mysqli_error($conn));
            echo $sql_update . '<br>';
        }
    }
}

mysqli_close($conn);
?>
