<?php
session_start();
$is_logged_in = isset($_SESSION['user_name']) && $_SESSION['user_name'] != '';
$title = $_SESSION['title'] ?? '';
$department = $_SESSION['department'] ?? '';

// Define the base path
$base_path = '../';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <title>TDU Dashboard</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            background-color: #334155;
            border-bottom: 2px solid #e7e7e7;
        }
        
        .logo {
            flex: 2;
        }
        
        .logo img {
            height: 50px;
        }
        
        nav {
            flex: 8;
            display: flex;
            justify-content: left;
            align-items: center;
        }
        
        nav ul {
            list-style: none;
            display: flex;
            padding: 0;
            justify-content: space-between;
        }
        
        nav ul li {
            margin: auto;
            position: relative;
        }
        
        nav ul li a {
            text-decoration: none;
            color: white;
            font-size: 18px;
            padding: 10px 50px;
            display: block;
        }
        
        nav ul li ul {
            position: absolute;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            display: none;
            background-color: #334155;
            list-style: none;
            padding: 10px 0;
            z-index: 1000;
            white-space: nowrap;
        }
        
        nav ul li:hover ul {
            display: block;
        }
        
        nav ul li ul li {
            display: block;
            margin: 0;
        }
        
        nav ul li ul li button {
            display: block;
            width: 100%;
            background-color: transparent;
            color: white;
            border: none;
            padding: 20px 50px;
            cursor: pointer;
            font-size: 16px;
            text-align: center;
        }
        
        nav ul li ul li button:hover {
            background-color: #ffbb00;
            color: black;
        }
        
        .auth {
            flex: 1;
            text-align: right;
        }
        
        .auth a {
            text-decoration: none;
            color: white;
            font-size: 18px;
            margin-left: 15px;
        }
    </style>
</head>
<body>

<header>
    <!-- Logo -->
    <div class="logo">
        <a href="<?php echo $base_path; ?>quote.php"><img src="images/logo.png" alt="TDU"></a>
    </div>

    <!-- Navigation -->
    <nav>
        <ul>
            <?php if ($is_logged_in) { ?>
                <li>
                    <a href="#">Quote</a>
                    <ul>
                        <?php if ($title == 'admin' || $title == 'ops') { ?>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=search'">View All Quotes</button>
                            </li>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>?opt=create-standard'">New Standard Group Quote</button>
                            </li>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>?opt=create-group'">New Pax Range Quote</button>
                            </li>
                        <?php } ?>
                        <?php if ($title == 'sales') { ?>
                            <li>
                                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=sales-search'">View All Quotes</button>
                            </li>
                        <?php } ?>
                    </ul>
                </li>
            <?php } ?>
            <?php if ($is_logged_in) { ?>
                <li>
                    <a href="<?php echo $base_path; ?>quote.php?opt=ops-group">Operation</a>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'sales') { ?>
                <li>
                    <a href="#">Sales</a>
                    <ul>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=sales-home'">Internal Sales</button>
                        </li>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=sales-home-external'">External Sales</button>
                        </li>
                    </ul>
                </li>
            <?php } ?>
            <?php if ($is_logged_in) { ?>
                <li>
                    <a href="#">Hotel</a>
                    <ul>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=hotel&country=au'">Australia</button>
                        </li>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=hotel&country=nz'">New Zealand</button>
                        </li>
                    </ul>
                </li>
            <?php } ?>
            <?php if ($is_logged_in) { ?>
                <li>
                    <a href="<?php echo $base_path; ?>car-hire/">Car Hire</a>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'ops') { ?>
                <li>
                    <a href="#">AU Vendor</a>
                    <ul>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=vendor&country=au&category=Attraction'">Attraction</button>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=vendor&country=au&category=Restaurant'">Restaurant</button>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=vendor&country=au&category=Transfer'">Transfer</button>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=add-vendor'">New</button>
                        </li>
                    </ul>
                </li>
            <?php } ?>
            <?php if ($title == 'admin' || $title == 'ops') { ?>
                <li>
                    <a href="#">Report</a>
                    <ul>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-payment-deadline'">Group Payment Deadline</button>
                        </li>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-hotel-deadline'">Hotel Deadline</button>
                        </li>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-ops'">Operation Overview</button>
                        </li>
                        <li>
                            <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=report-sales'">Sales Overview</button>
                        </li>
                    </ul>
                </li>
            <?php } ?>
            <?php if ($is_logged_in) { ?>
                <li>
                    <a href="https://gtxsupport.hesk.com/" target="_blank">Help Desk</a>
                </li>
            <?php } ?>
        </ul>
    </nav>

    <!-- Login/Logout -->
    <div class="auth">
        <?php if ($is_logged_in): ?>
            <span style="color: white;"><?php echo $_SESSION['user_name']; ?></span>
            <a href="<?php echo $base_path; ?>logout.php" title="logout"><i class="fas fa-sign-out-alt"></i></a>
        <?php else: ?>
            <a href="<?php echo $base_path; ?>login.php">login</a>
        <?php endif; ?>
    </div>

    <style>
        .auth .dropdown {
            position: relative;
            display: inline-block;
        }
        
        .auth .dropbtn {
            background-color: transparent;
            border: none;
            color: white;
            cursor: pointer;
            font-size: 18px;
            padding: 10px;
        }
        
        .auth .dropdown-content {
            display: none;
            position: absolute;
            background-color: #334155;
            min-width: 160px;
            z-index: 1;
        }
        
        .auth .dropdown-content button {
            width: 100%;
            background-color: transparent;
            color: white;
            border: none;
            padding: 10px 20px;
            text-align: left;
            cursor: pointer;
        }
        
        .auth .dropdown-content button:hover {
            background-color: #ffbb00;
        }
        
        .auth .dropdown:hover .dropdown-content {
            display: block;
        }
    </style>
</header>

</body>
</html>
