<?php
// chatbot.php (Chatbot UI File - Nice UI Structure, Original Colors, Larger Size)

function generateChatbot() {
    ob_start();
    // Start session if not already started
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }
    // Unique prefix for IDs and classes
    $prefix = 'tai_cb_';
    ?>
    <style>
        /* --- UI STYLES --- */

        #<?php echo $prefix; ?>container {
            /* Positioning container */
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
            font-family: sans-serif; /* Original font */
            transition: width 0.3s ease, height 0.3s ease;
        }

        /* Toggle Button (Minimized State) - Original Colors & Text */
        #<?php echo $prefix; ?>toggle_button {
            background-color: #334155; /* Original dark slate */
            color: white;
            border: none;
            border-radius: 50%; /* Keep it round */
            width: 90px; /* Original size */
            height: 90px; /* Original size */
            font-size: 16px; /* Adjust if needed for text */
            font-weight: bold; /* Make text clearer */
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
            transition: background-color 0.2s ease, transform 0.2s ease;
            position: absolute;
            bottom: 0;
            right: 0;
            text-align: center; /* Center text */
            padding: 5px; /* Add padding for text */
            line-height: 1.2; /* Adjust line height for multi-line text */
        }
         #<?php echo $prefix; ?>toggle_button:hover {
             background-color: #475569; /* Slightly darker slate */
             transform: scale(1.03); /* Smaller hover effect */
         }
         /* Removed ::before icon style */


        /* Chat Window Content (Expanded State) - Larger Size */
        #<?php echo $prefix; ?>content {
            width: 600px; /* Significantly Wider */
            height: 750px; /* Significantly Taller */
            display: none; /* Hidden initially */
            flex-direction: column;
            background-color: #ffffff; /* White background */
            border-radius: 8px; /* Slightly less rounded */
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1); /* Subtler shadow */
            overflow: hidden;
            position: absolute;
            bottom: 0;
            right: 0;
            border: 1px solid #ccc; /* Original border color */
        }

        /* Header - Neutral styling */
        #<?php echo $prefix; ?>header {
             background-color: #f7f7f7; /* Light neutral grey */
             padding: 10px 15px;
             display: flex;
             justify-content: space-between;
             align-items: center;
             border-bottom: 1px solid #ccc; /* Original border color */
             flex-shrink: 0;
        }
         #<?php echo $prefix; ?>title {
             font-weight: bold; /* Make title stand out */
             color: #333; /* Dark grey text */
             font-size: 16px;
         }
        #<?php echo $prefix; ?>close_button {
             background: none;
             border: none;
             font-size: 24px;
             color: #555; /* Medium grey */
             cursor: pointer;
             padding: 5px;
             line-height: 1;
         }
        #<?php echo $prefix; ?>close_button:hover {
             color: #000; /* Black on hover */
         }


        /* Chat Log Area */
        #<?php echo $prefix; ?>log {
            flex-grow: 1;
            overflow-y: auto;
            padding: 15px;
            display: flex;
            flex-direction: column;
            gap: 8px; /* Slightly less gap */
            background-color: #ffffff; /* White background */
             /* Simple Scrollbar (Optional - remove if undesired) */
             scrollbar-width: thin;
             scrollbar-color: #ccc #f7f7f7;
        }
        /* Basic WebKit scrollbar to match theme */
        #<?php echo $prefix; ?>log::-webkit-scrollbar { width: 8px; }
        #<?php echo $prefix; ?>log::-webkit-scrollbar-track { background: #f7f7f7; }
        #<?php echo $prefix; ?>log::-webkit-scrollbar-thumb { background: #ccc; border-radius: 4px;}
        #<?php echo $prefix; ?>log::-webkit-scrollbar-thumb:hover { background: #aaa; }


        /* Message Base - Minimal styling */
        .<?php echo $prefix; ?>message_base {
            padding: 2px 0; /* Minimal vertical padding */
            line-height: 1.4;
            word-wrap: break-word;
            font-size: 14px; /* Original font size */
        }

        /* User Message - Original Colors */
        .<?php echo $prefix; ?>user_message {
             /* Inherits from base */
             text-align: right; /* Original alignment */
             color: #007bff; /* Original blue text */
             margin-left: auto; /* Push right */
             margin-right: 5px; /* Small margin from edge */
             /* Removed background/border-radius for original look */
        }

        /* Bot Message - Original Colors */
        .<?php echo $prefix; ?>bot_message {
            /* Inherits from base */
            text-align: left; /* Original alignment */
            color: black; /* Original black text */
            margin-right: auto; /* Push left */
             margin-left: 5px; /* Small margin from edge */
             /* Removed background/border-radius for original look */
        }

        /* Loading Placeholder Style - Original Colors */
        .<?php echo $prefix; ?>loading_placeholder {
             color: #777; /* Original grey text */
             font-style: italic;
        }
        /* Simple loading dots (optional) */
        .<?php echo $prefix; ?>loading_placeholder .dot {
            display: inline-block;
            animation: <?php echo $prefix; ?>blink 1.4s infinite both;
            animation-delay: 0.5s; /* Start dots slightly later */
         }
        .<?php echo $prefix; ?>loading_placeholder .dot:nth-child(1) { animation-delay: 0.5s; }
        .<?php echo $prefix; ?>loading_placeholder .dot:nth-child(2) { animation-delay: 0.7s; }
        .<?php echo $prefix; ?>loading_placeholder .dot:nth-child(3) { animation-delay: 0.9s; }
        @keyframes <?php echo $prefix; ?>blink {
             0%, 100% { opacity: 0.2; } 50% { opacity: 1; }
         }


        /* Input Area - Neutral styling */
        #<?php echo $prefix; ?>input_area {
             display: flex;
             padding: 10px 15px;
             border-top: 1px solid #ccc; /* Original border color */
             background-color: #f7f7f7; /* Light neutral grey */
             flex-shrink: 0;
        }

        /* Input Field - Original look */
        #<?php echo $prefix; ?>input {
            flex-grow: 1;
            border: 1px solid #ccc; /* Original border */
            border-radius: 4px; /* Standard border radius */
            padding: 8px 10px; /* Original padding */
            font-size: 14px;
            outline: none;
            transition: border-color 0.2s ease;
            margin-right: 0; /* No margin needed if no send button */
        }
         #<?php echo $prefix; ?>input:focus {
             border-color: #007bff; /* Blue focus like user text */
         }

         /* --- State Handling (CSS Classes) --- */
         #<?php echo $prefix; ?>container.<?php echo $prefix; ?>expanded #<?php echo $prefix; ?>toggle_button {
             display: none; /* Hide toggle button when expanded */
         }
         #<?php echo $prefix; ?>container.<?php echo $prefix; ?>expanded #<?php echo $prefix; ?>content {
             display: flex; /* Show content */
         }

         #<?php echo $prefix; ?>container.<?php echo $prefix; ?>minimized #<?php echo $prefix; ?>content {
             display: none; /* Hide content */
         }
         #<?php echo $prefix; ?>container.<?php echo $prefix; ?>minimized #<?php echo $prefix; ?>toggle_button {
             display: flex; /* Show toggle button */
         }

    </style>

    <!-- Container with state class -->
    <div id="<?php echo $prefix; ?>container" class="<?php echo $prefix; ?>minimized">

        <!-- Toggle Button (Text restored) -->
        <button id="<?php echo $prefix; ?>toggle_button" title="Ask TAI">Ask TAI</button>

        <!-- Chat Content -->
        <div id="<?php echo $prefix; ?>content">
            <!-- Header -->
            <div id="<?php echo $prefix; ?>header">
                <span id="<?php echo $prefix; ?>title">Ask TAI</span>
                <button id="<?php echo $prefix; ?>close_button" title="Close Chat">×</button>
            </div>
            <!-- Chat Log -->
            <div id="<?php echo $prefix; ?>log">
                <?php
                // Display initial message or history
                if (empty($_SESSION['chat_history'])) {
                    echo '<div class="' . $prefix . 'bot_message ' . $prefix . 'message_base">Welcome! How can I help you?</div>';
                } else {
                    foreach ($_SESSION['chat_history'] as $turn) {
                        $message_class = ($turn['role'] === 'user') ? $prefix . 'user_message' : $prefix . 'bot_message';
                        // Output RAW HTML from session - ensure it is safe!
                        echo '<div class="' . $message_class . ' ' . $prefix . 'message_base">' . $turn['message'] . '</div>';
                    }
                }
                ?>
                <!-- Dynamic messages appear here -->
                <script>
                    // Scroll down on initial load if needed
                     document.addEventListener('DOMContentLoaded', function() {
                        const chatLogElement = document.getElementById('<?php echo $prefix; ?>log');
                         if(chatLogElement && chatLogElement.scrollHeight > chatLogElement.clientHeight) {
                             chatLogElement.scrollTop = chatLogElement.scrollHeight;
                         }
                     });
                </script>
            </div>
            <!-- Input Area -->
            <div id="<?php echo $prefix; ?>input_area">
                 <input type="text" id="<?php echo $prefix; ?>input" placeholder="Type your message...">
            </div>
        </div>
    </div>

    <script>
        // Wrap in IIFE (Immediately Invoked Function Expression) to avoid global scope issues
        (function() {
            // Get references to elements using unique IDs
            const prefix = '<?php echo $prefix; ?>';
            const chatContainer = document.getElementById(prefix + 'container');
            const toggleChatButton = document.getElementById(prefix + 'toggle_button');
            const closeChatButton = document.getElementById(prefix + 'close_button');
            const chatContent = document.getElementById(prefix + 'content');
            const chatInput = document.getElementById(prefix + 'input');
            const chatLog = document.getElementById(prefix + 'log');
            let messageCounter = 0; // Counter for unique loading message IDs

            // Function to scroll the chat log to the bottom
            function scrollToBottom() {
                // Use a small timeout to ensure DOM has updated before scrolling
                setTimeout(() => { chatLog.scrollTop = chatLog.scrollHeight; }, 50);
            }

            // Function to open the chat window
            function openChat() {
                // Use CSS classes to control visibility and state
                chatContainer.classList.remove(prefix + 'minimized');
                chatContainer.classList.add(prefix + 'expanded');
                chatInput.focus(); // Focus the input field
                scrollToBottom(); // Scroll down in case there's initial content
            }

            // Function to close the chat window
            function closeChat() {
                // Use CSS classes to control visibility and state
                chatContainer.classList.remove(prefix + 'expanded');
                chatContainer.classList.add(prefix + 'minimized');
            }

            // --- Event Listeners ---
            // Click toggle button to open chat
            toggleChatButton.addEventListener('click', openChat);
            // Click close button to close chat
            closeChatButton.addEventListener('click', closeChat);

            // Listen for Enter key in the input field
            chatInput.addEventListener('keypress', function (e) {
                // Check if Enter key was pressed and input is not just whitespace
                if (e.key === 'Enter' && chatInput.value.trim() !== '') {
                    const message = chatInput.value.trim(); // Get the message
                    chatInput.value = ''; // Clear the input field

                    // 1. Display User's Message
                    // Append user message using original styling class
                    // WARNING: Directly inserting 'message' assumes it's plain text or safe HTML.
                    chatLog.innerHTML += `<div class="${prefix}user_message ${prefix}message_base">${message}</div>`;
                    scrollToBottom(); // Scroll down

                    // 2. Display Loading Placeholder
                    const loadingId = prefix + 'msg_' + (messageCounter++); // Generate unique ID
                    // Append placeholder using original styling class and loading class
                    chatLog.innerHTML += `
                        <div id="${loadingId}" class="${prefix}bot_message ${prefix}message_base ${prefix}loading_placeholder">
                            Loading<span class="dot">.</span><span class="dot">.</span><span class="dot">.</span>
                        </div>`;
                    scrollToBottom(); // Scroll down

                    // 3. Send message to server (AJAX using Fetch API)
                    fetch('ajax_chatbot.php', { // Endpoint for backend logic
                        method: 'POST',
                        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                        body: `message=${encodeURIComponent(message)}` // Send message URL-encoded
                    })
                    .then(response => {
                        // Check if the server response is successful (status code 200-299)
                         if (!response.ok) {
                            // If not okay, create an error to be caught below
                            throw new Error(`HTTP error! Status: ${response.status}`);
                         }
                         return response.text(); // Get the response body as text
                    })
                    .then(data => {
                        // 4. Replace Placeholder with Actual Bot Response
                        const messageElement = document.getElementById(loadingId); // Find the placeholder
                        if (messageElement) {
                            // WARNING: Directly inserting 'data' assumes it's plain text or safe HTML from the server.
                            messageElement.innerHTML = data; // Update content
                            messageElement.classList.remove(prefix + 'loading_placeholder'); // Remove loading style
                            // Ensure base and bot classes remain if innerHTML overwrote them
                            if (!messageElement.classList.contains(prefix + 'message_base')) {
                                messageElement.classList.add(prefix + 'message_base');
                             }
                            if (!messageElement.classList.contains(prefix + 'bot_message')) {
                                messageElement.classList.add(prefix + 'bot_message');
                             }
                        }
                        scrollToBottom(); // Scroll down after adding message
                    })
                     .catch(error => {
                         // Handle errors during the fetch process
                         console.error("Chatbot Fetch Error:", error);
                         // 4b. Replace placeholder with an error message for the user
                         const messageElement = document.getElementById(loadingId);
                         if (messageElement) {
                             messageElement.innerHTML = "Sorry, an error occurred."; // Simple error message
                             messageElement.classList.remove(prefix + 'loading_placeholder');
                         }
                         scrollToBottom(); // Scroll down
                    });
                }
            });

            // Initial scroll check is handled by the inline script in the chat log div

        })(); // End of IIFE
    </script>
    <?php

    $chatbotHTML = ob_get_clean(); // Get the buffered HTML
    return $chatbotHTML; // Return the HTML string
}

// --- Example Usage ---
// To display the chatbot, simply call the function:
 echo generateChatbot();

?>