<?php
function getAllCities($conn){
    $sql_city = "SELECT DISTINCT vpcf.city AS City FROM vtiger_inventoryproductrel vi
                 LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid";
    $result = mysqli_query($conn, $sql_city); // Execute the query

    $cities = array(); // Initialize the array *before* the loop

    if ($result) { // Check if the query was successful
        while ($row = mysqli_fetch_assoc($result)) {
            $city = $row['City']; // Get the city value
            if (!empty($city)) { //Check if the city name is empty or not. If it's not empty, add it to the array.
              $cities[] = $city; // Add the city to the array
            }
        }
        mysqli_free_result($result); // Free the result set (good practice)
    } else {
        // Handle the error (e.g., log it, return an empty array, etc.)
        error_log("Error in getAllCities query: " . mysqli_error($conn));
        return array(); // Return an empty array in case of error
    }

    return $cities;
}

function getAllCountries($conn){
    $sql_countries = "SELECT DISTINCT vpcf.country AS Country FROM vtiger_inventoryproductrel vi
                 LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid";
    $result = mysqli_query($conn, $sql_countries); // Execute the query

    $countries = array(); // Initialize the array *before* the loop

    if ($result) { // Check if the query was successful
        while ($row = mysqli_fetch_assoc($result)) {
            $country = $row['Country']; // Get the city value
            if (!empty($country)) { //Check if the city name is empty or not. If it's not empty, add it to the array.
              $countries[] = $country; // Add the city to the array
            }
        }
        mysqli_free_result($result); // Free the result set (good practice)
    } else {
        // Handle the error (e.g., log it, return an empty array, etc.)
        error_log("Error in getAllCountries query: " . mysqli_error($conn));
        return array(); // Return an empty array in case of error
    }

    return $countries;
}

function getCitiesByCountry($conn) {
    $sql_city = "SELECT DISTINCT vpcf.city AS City, vpcf.country AS Country 
                 FROM vtiger_inventoryproductrel vi
                 LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid";
    $result = mysqli_query($conn, $sql_city);

    $citiesByCountry = array();

    if ($result) {
        while ($row = mysqli_fetch_assoc($result)) {
            $city = $row['City'];
            $country = $row['Country'];

            if (!empty($city) && !empty($country)) { // Ensure both city and country are present
                if (!isset($citiesByCountry[$country])) {
                    $citiesByCountry[$country] = array(); // Initialize country array if it doesn't exist
                }
                $citiesByCountry[$country][] = $city; // Add city to the country's array
            }
        }
        mysqli_free_result($result);
    } else {
        error_log("Error in getCitiesByCountry query: " . mysqli_error($conn));
        return array();
    }

    return $citiesByCountry;
}

function getCitiesString($quoteid, $conn){
    $sql_city = "SELECT DISTINCT vpcf.city AS cf_1248 FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid
                WHERE vi.id='$quoteid';";
    $result_city = mysqli_query($conn, $sql_city);
    $cities = array();
    $citiesString = "";
    if ($result_city && mysqli_num_rows($result_city) > 0) {
        while($row_city = mysqli_fetch_assoc($result_city)) {
            if(isset($row_city['cf_1248']) && $row_city['cf_1248'] != '') {
                $cities[] = $row_city['cf_1248'];
            }
        }
    }
    if (isset($_GET['city']) && !empty($_GET['city'])) {
        $cityQuery = strtolower($_GET['city']);
        $found = false;
        foreach ($cities as $city) {
            if (strpos(strtolower($city), $cityQuery) !== false) {
                $found = true;
                break;
            }
        }
        if (!$found) {
            return "";
        }
    }
    if ($result_city && mysqli_num_rows($result_city) > 0) {
        //echo (implode(', ', $cities));
        $citiesString = implode(', ', $cities);
    }
    return $citiesString;
}

function getCities($quoteid, $conn){
    $sql_city = "SELECT DISTINCT vpcf.city AS cf_1248 FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vpcf ON vi.productid=vpcf.productid
                WHERE vi.id='$quoteid';";
    $result_city = mysqli_query($conn, $sql_city);
    $cities = array();
    if ($result_city && mysqli_num_rows($result_city) > 0) {
        while($row_city = mysqli_fetch_assoc($result_city)) {
            if(isset($row_city['cf_1248']) && $row_city['cf_1248'] != '') {
                $cities[] = $row_city['cf_1248'];
            }
        }
    }
    if (isset($_GET['city']) && !empty($_GET['city'])) {
        $cityQuery = strtolower($_GET['city']);
        $found = false;
        foreach ($cities as $city) {
            if (strpos(strtolower($city), $cityQuery) !== false) {
                $found = true;
                break;
            }
        }
        if (!$found) {
            return "";
        }
    }
    return $cities;
}
?>