<?php
$statusMapping = [
    "pre_sale" => [
        "Created",
        "Create Project",
        "Requote"
    ],
    "confirmed" => [
        "Accepted",
        "Accepted - Groups",
        "Accepted - Partial Land Booking Done",
        "Accepted - PRE QA - Land Bookings",
        "Payment Received - Release Vouchers",
        "Requote After Confirmation",
        "Final Land Booking Done (Ops)",
        "Final QA",
        "Final QA (Rakesh/Kunjan)",
        "Accepted - Pre QA Start Bookings"
    ],
    "Rejected" => [
        "Auto Rejected",
        "Rejected",
        "Rejected After Confirmation"
    ],
    "Delivered" => [
        "Delivered",
        "On Ground - Changes (Ops)",
        "Accounts - Reconciliation",
        "Accounts - Reconciliation (Rakesh/Kunjan)",
        "Completed (Accounts)"
    ]
];
$listSalesAgents = fetchInternalSales($conn);

// Start the SQL query
$sql = "SELECT 
        COALESCE(NULLIF(vqinfo.assigned_to_sales_agent, ''), 'unassigned') AS agent_name";

// Loop to create dynamic counts for each category and each month (0 to 11 months)
for ($i = 0; $i <= 11; $i++) {
    foreach ($statusMapping as $category => $statusList) {
        $statusListStr = "'" . implode("','", $statusList) . "'";
        $sql .= ",
        COUNT(CASE WHEN vq.quotestage IN ($statusListStr) 
                AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL $i MONTH)) 
                AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL $i MONTH)) 
                THEN vq.quoteid END) AS {$category}_count_next_month_{$i}";
    }
}

$sql .= " FROM (
    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'group' AS source
    FROM vtiger_quotes vq
    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
    WHERE vq.quoteid IN (
            SELECT MIN(sub.quoteid)
            FROM vtiger_quotes AS sub
            GROUP BY sub.quote_no
    )
    UNION
    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'crm' AS source
    FROM vtiger_quotes_crm vq
    LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid = vqcf.quoteid
    WHERE vqcf.cf_1162 >= '2024-10-01'
) vq
LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
WHERE vq.cf_1162 >= '2024-10-01'
GROUP BY agent_name
HAVING agent_name LIKE '%$tagFilter%' OR agent_name = 'unassigned'
ORDER BY (agent_name = 'unassigned') DESC, agent_name";

$result = $conn->query($sql);

if ($result->num_rows > 0): ?>
    <div class="table-container" style="width: 70%; margin: auto;">
        <div class="table-wrapper">
            <h2 style="margin-bottom: 10px;">Quotes</h2>
            <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; text-align: center;">
                <thead>
                    <tr>
                        <th>Agent-Category</th>
                        <?php for ($i = 0; $i <= 11; $i++): ?>
                            <th><?= date('M-y', strtotime("+$i months")) ?></th>
                        <?php endfor; ?>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <?php
                        if ($title != 'admin' && trim($row['agent_name']) != trim($username_ajax) && $row['agent_name'] != 'unassigned') {
                            continue;
                        }
                        if(!in_array($row['agent_name'], $listSalesAgents) && $row['agent_name'] != 'unassigned') {
                            continue;
                        }
                        ?>
                        <tr>
                            <?php
                            if ($row['agent_name'] == 'unassigned') {
                                $red_unassigned = ' style="background-color: #ffd1d1;"';
                                ?>
                                <td colspan="14" style="text-align: center; background-color: #ffd1d1;"><strong>Unassigned</strong></td>
                                <?php
                            }
                            else {
                                $red_unassigned = '';
                                ?>
                                <td colspan='14' style="text-align: center;"><strong><?= $row['agent_name'] ?></strong></td>
                                <?php
                            }
                            ?>
                        </tr>
                        <?php
                        // Loop through each status category (e.g., pre_sale, confirmed)
                        foreach ($statusMapping as $category => $statusList):
                            // Create a comma-separated list of statuses
                            $statusQueryString = implode(",", $statusList);
                            $total_count = 0; // Initialize total for the category
                            ?>
                            <tr <?= $red_unassigned ?>>
                                <td><?= ucwords(str_replace('_', ' ', $category)) ?></td>
                                <?php for ($i = 0; $i <= 11; $i++): ?>
                                    <?php
                                    $count = $row["{$category}_count_next_month_$i"];
                                    $total_count += $count; // Add to total
                                    if ($count == 0) {
                                        echo '<td style="width: 7%;"></td>';
                                    } else {
                                        $first_day = date('Y-m-01', strtotime("+$i months"));
                                        $last_day = date('Y-m-t', strtotime("+$i months"));
                                        $date_range = "$first_day to $last_day";
                                        // Add &quote_stage parameter with comma-separated statuses
                                        echo "<td style='width: 7%;'><a href='quote.php?opt=sales-search&quote_type=fit&date_range=$date_range&assigned_to_sales_agent=" . urlencode($row['agent_name']) . "&quote_stage=$statusQueryString'>$count</a></td>";
                                    }
                                    ?>
                                <?php endfor; ?>
                                <td><?= $total_count ?></td> <!-- Display total for the category -->
                            </tr>
                        <?php endforeach; ?>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php endif; ?>
