<h1 style="text-align: center; margin-top: 20px;">MailBox</h1>

<?php
$sql = "SELECT 
                te.mailbox,
                COUNT(DISTINCT CASE WHEN (vs.status = 'Closed') THEN te.conversation_id END) AS closed_count,
                COUNT(DISTINCT CASE WHEN (vs.status = 'In Progress') THEN te.conversation_id END) AS in_progress_count,
                COUNT(DISTINCT CASE WHEN (vs.status = 'Wait For Response') THEN te.conversation_id END) AS waiting_count,
                COUNT(DISTINCT CASE WHEN (vs.status IS NULL OR vs.status = '') THEN te.conversation_id END) AS new_count,
                COUNT(DISTINCT CASE WHEN (vfo.object_id IS NULL AND (vs.status IS NULL OR (vs.status != 'Closed' AND vs.status != 'SPAM'))) THEN te.conversation_id END) AS unassigned_count
        FROM 
                tdu_emails te
        LEFT JOIN 
                vtiger_support vs ON te.conversation_id = vs.ticketid
        LEFT JOIN 
                vtiger_freetagged_objects vfo ON te.conversation_id = vfo.object_id
        JOIN (
                SELECT conversation_id, MAX(received_datetime) AS latest_received_datetime
                FROM tdu_emails
                WHERE folder = 'Inbox'
                GROUP BY conversation_id
        ) AS latest_email
                ON te.conversation_id = latest_email.conversation_id 
                AND te.received_datetime = latest_email.latest_received_datetime
        GROUP BY 
                te.mailbox
        ";
$result = mysqli_query($conn, $sql);

?>
<div class="table-container" style="width: 70%; margin: auto;">
        <div class="table-wrapper">
        <?php
        $categories = [
                "Sales" => ["sales@turtledownunder.com.au", "groupsales@turtledownunder.com.au"],
                "Operation" => ["operations@turtledownunder.com.au", "groups@turtledownunder.com.au", "groups@turtledownunder.co.nz", "operations@turtledownunder.co.nz"],
                "Accounts" => ["accounts@turtledownunder.com.au", "accounts@turtledownunder.co.nz"],
                "Contracts" => ["contracts@turtledownunder.com.au", "contracts@turtledownunder.co.nz"],
                "Asia" => ["asia@turtledownunder.com.au"]
        ];

        if (mysqli_num_rows($result) > 0) {
                foreach ($categories as $category => $emails) {
                mysqli_data_seek($result, 0); // Reset the result pointer
                $rows = []; // Collect rows for sorting
                $hasRows = false;

                // Collect rows for this category
                while ($row = mysqli_fetch_assoc($result)) {
                        if (in_array($row['mailbox'], $emails)) {
                        $allowed = getEmailsByRole($title);
                        if (in_array($row['mailbox'], $allowed)) {
                                $rows[] = $row;
                                $hasRows = true;
                        }
                        }
                }

                // Sort rows by domain (.au first, then .nz)
                usort($rows, function ($a, $b) {
                        $domainA = substr(strrchr($a['mailbox'], "."), 1);
                        $domainB = substr(strrchr($b['mailbox'], "."), 1);
                        return strcmp($domainA, $domainB); // Compare domains alphabetically
                });

                if ($hasRows) {
                        ?>
                        <h3><?php echo $category; ?></h3>
                        <table style="margin: 10px 0;">
                        <tr>
                                <th>Email</th>
                                <th>Untagged</th>
                                <th>New</th>
                                <th>In Progress</th>
                                <th>Wait For Response</th>
                                <th>Closed</th>
                                <th></th>
                        </tr>
                        <?php

                        $previousDomain = null;

                        foreach ($rows as $row) {
                        $currentDomain = substr(strrchr($row['mailbox'], "."), 1);

                        // Add an empty row if transitioning between domains
                        if ($previousDomain && $currentDomain !== $previousDomain) {
                                echo "<tr><td colspan='6' style='height: 10px;'></td></tr>";
                        }

                        // Display the current row
                        ?>
                        <tr>
                                <td style="width: 20%;">
                                <a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>">
                                        <?php echo htmlspecialchars($row['mailbox']); ?>
                                </a>
                                </td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&userid=unassigned"><?php echo htmlspecialchars($row['unassigned_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=New"><?php echo htmlspecialchars($row['new_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=In Progress"><?php echo htmlspecialchars($row['in_progress_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=Wait For Response"><?php echo htmlspecialchars($row['waiting_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&status=Closed"><?php echo htmlspecialchars($row['closed_count']); ?></a></td>
                                <td><a href="quote.php?opt=office-mailbox&mailbox=<?php echo urlencode($row['mailbox']); ?>&folder=sent">Sent Items</a></td>
                        </tr>
                        <?php

                        // Update the previous domain
                        $previousDomain = $currentDomain;
                        }
                        echo "</table>";
                }
                }
        } else {
                echo "<p style='text-align:center;'>No records available.</p>";
        }
        ?>
        </div>
</div>

<style>
        .table-wrapper tr td {
        width: 12%;
        }
        .table-wrapper a {
        text-decoration: none;
        }
</style>
