<?php
include "dbconn.php";

// Fetch sales and external users
$sql = "SELECT DISTINCT CONCAT(first_name, ' ', last_name) AS full_name, 
        CASE 
            WHEN title = 'sales' THEN 'internal' 
            WHEN title = 'external' THEN 'external' 
        END AS category 
        FROM vtiger_users 
        WHERE title IN ('sales', 'external')";

$result = mysqli_query($conn, $sql);

if (!$result) {
    die("Query failed: " . mysqli_error($conn));
}

// Store processed names to track inserted/updated users
$processed_names = [];

while ($row = mysqli_fetch_assoc($result)) {
    $full_name = mysqli_real_escape_string($conn, $row['full_name']);
    $category = mysqli_real_escape_string($conn, $row['category']);
    
    // Insert or update record
    $update_sql = "INSERT INTO tdu_agents (name, category) 
                   VALUES ('$full_name', '$category')
                   ON DUPLICATE KEY UPDATE 
                   category = VALUES(category)";
    
    if (mysqli_query($conn, $update_sql)) {
        $processed_names[] = $full_name;
    } else {
        echo "Error updating record: " . mysqli_error($conn) . "\n";
    }
}

// Convert array to string for SQL query
$processed_names_list = "'" . implode("','", $processed_names) . "'";

// Update other users to category 'none' who were not in the fetched list
if (!empty($processed_names)) {
    $reset_sql = "UPDATE tdu_agents 
                  SET category = 'none' 
                  WHERE name NOT IN ($processed_names_list)";
} else {
    $reset_sql = "UPDATE tdu_agents SET category = 'none'";
}

if (!mysqli_query($conn, $reset_sql)) {
    echo "Error updating remaining records: " . mysqli_error($conn) . "\n";
}

mysqli_close($conn);
echo "tdu_agents table updated successfully.\n";
?>
