<?php
include "dbconn.php";
include __DIR__ . '/../dictionaries.php';

$blocked_users = getBlockedUsers($conn);

$today = date('Y-m-d');
$past_7_days = date('Y-m-d', strtotime('-7 days'));
$next_7_days = date('Y-m-d', strtotime('+6 days'));

$agent_types = [
    'internal' => 'assigned_to_sales_agent',
    'external' => 'assigned_to_external_sales_agent',
];

$date_fields = [
    'next_follow_up_date' => [
        'sql_column' => 'vqf.next_follow_up_date',
        'date_condition' => "DATE(vqf.next_follow_up_date) BETWEEN '$past_7_days' AND '$next_7_days'"
    ],
    'calltime' => [
        'sql_column' => 'vqf.calltime',
        'date_condition' => "DATE(vqf.calltime) BETWEEN '$past_7_days' AND '$today'"
    ],
];

$section_data = [];

foreach ($date_fields as $field_key => $field_info) {
    $section_data[$field_key] = [
        'data' => [],
        'all_dates' => [],
    ];

    foreach ($agent_types as $agent_type => $agent_column) {
        $date_column_sql = $field_info['sql_column'];
        $date_condition = $field_info['date_condition'];

        $sql = "SELECT vqinfo.$agent_column AS agent, DATE($date_column_sql) AS follow_up_date
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                LEFT JOIN vtiger_quotes_followup vqf ON vq.quoteid = vqf.quoteid AND vqf.quotetype = 'group'
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
                WHERE $date_condition";

        $result = mysqli_query($conn, $sql);

        while ($row = mysqli_fetch_assoc($result)) {
            $agent = !empty($row['agent']) ? $row['agent'] : 'Unassigned';
            if ($agent == 'Unassigned') continue;
            if (in_array($agent, $blocked_users)) {
                continue; // Skip blocked users
            }

            $date = $row['follow_up_date'] ?: 'No Date';
            $section_data[$field_key]['all_dates'][$date] = true;

            $key = "$agent_type|$agent";
            if (!isset($section_data[$field_key]['data'][$key][$date])) {
                $section_data[$field_key]['data'][$key][$date] = 0;
            }
            $section_data[$field_key]['data'][$key][$date]++;
        }
    }
}

// Write merged CSV with two sections
$final_filename = "sales_call_report_{$past_7_days}_to_{$next_7_days}.csv";
$final_filepath = __DIR__ . "/../sys_csv_report/" . $final_filename;

$fp = fopen($final_filepath, 'w');

foreach ($section_data as $field_key => $section) {
    $label = strtoupper(str_replace('_', ' ', $field_key));
    fputcsv($fp, ["-- $label --"]);

    $all_dates = array_keys($section['all_dates']);
    sort($all_dates);
    fputcsv($fp, array_merge(['Agent Type', 'Agent'], $all_dates));

    ksort($section['data']);
    foreach ($section['data'] as $key => $dates) {
        list($agent_type, $agent) = explode('|', $key);
        $row = [$agent_type, $agent];
        foreach ($all_dates as $date) {
            $row[] = $dates[$date] ?? 0;
        }
        fputcsv($fp, $row);
    }

    fputcsv($fp, []); // Blank line between sections
}

fclose($fp);
echo "Generated: $final_filename\n";

// Email send
$recipients = [
    'haodongg@turtledownunder.com.au',
    'Abhisheks@turtledownunder.com.au',
    'Kunalr@turtledownunder.com.au'
];
sendSalesCallReport($recipients, $final_filepath);

function sendSalesCallReport($recipients, $final_filepath, $subject = "Sales Call Report", $body = "Please find the sales call report attached.") {
    $email_from = 'groupsales@turtledownunder.com.au';
    $secret = 'tdu_cronjob';

    foreach ($recipients as $email_to) {
        $post_data = [
            'from' => $email_from,
            'to' => $email_to,
            'compose' => 'Yes',
            'subject' => $subject,
            'content' => $body,
            'secret' => $secret,
            'attachments[0]' => new CURLFile($final_filepath)
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://dashboard.turtledownunder.com.au/email_sender.php");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);
        curl_close($ch);

        // Optional: Log or handle $response if needed
        echo "Email sent to $email_to: " . $response . "<br>";
    }
}
?>
