<?php
include "dbconn.php";
include __DIR__ . '/../quote_pricing.php';

$sql = "SELECT vq.quoteid, vqcf.cf_1162, vq.adults, vq.children, vq.infants, 
                vq.nsingle_room, vq.ndouble_room, vq.ntriple_room, vq.nchild_without_bed 
        FROM vtiger_quotes vq
        LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
        WHERE vq.quote_no NOT LIKE '%G'
            AND vqcf.cf_1162 > CURDATE()
            AND vq.quotestage IN (
                'Accepted', 
                'PRE QA - pending', 
                'PRE QA - completed', 
                'Payment Received - Release Vouchers', 
                'Final QA', 
                'Delivered', 
                'On Ground', 
                'Accounts - Reconciliation', 
                'Completed (Accounts)'
            );";
$result = mysqli_query($conn, $sql);

$assignment_map = [
    "sales" => "assigned_to_sales_agent",
    "external" => "assigned_to_external_sales_agent",
    "group" => "assigned_to_ops",
    "qa" => "assigned_to_qa"
];

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $quoteid = $row['quoteid'];
        $adults = $row['adults'] ?? 0;
        $children = $row['children'] ?? 0;
        $infants = $row['infants'] ?? 0;
        $single_rooms = $row['nsingle_room'] ?? 0;
        $double_rooms = $row['ndouble_room'] ?? 0;
        $triple_rooms = $row['ntriple_room'] ?? 0;
        $child_without_bed = $row['nchild_without_bed'] ?? 0;
        $child_no_bed = $children - $child_without_bed;

        // Fetch pricing details
        $pricing = getQuotePricing($conn, $quoteid, -1);
        $pricing_single_room = $pricing['single_room'];
        $pricing_double_room = $pricing['double_room'];
        $pricing_triple_room = $pricing['triple_room'];
        $pricing_child_with_bed = $pricing['child_with_bed'];
        $pricing_child_no_bed = $pricing['child_no_bed'];
        $pricing_infant = $pricing['infant'];

        // calculate total quote price
        $total_amount = 0;
        if ($single_rooms > 0) {
            $total_amount += $pricing_single_room * $single_rooms;
        }
        if ($double_rooms > 0) {
            $total_amount += $pricing_double_room * $double_rooms * 2;
        }
        if ($triple_rooms > 0) {
            $total_amount += $pricing_triple_room * ($triple_rooms * 3 - $child_with_bed);
        }
        if ($child_with_bed > 0) {
            $total_amount += $pricing_child_with_bed * $child_with_bed;
        }
        if ($child_no_bed > 0) {
            $total_amount += $pricing_child_no_bed * $child_no_bed;
        }
        if($infants > 0) {
            $total_amount += $pricing_infant * $infants;
        }

        $travel_month = date('n', strtotime($row['cf_1162'])); // Get month (1-12)
        $travel_day = date('j', strtotime($row['cf_1162']));   // Get day (1-31)
        $travel_month = (int) $travel_month;
        $travel_day = (int) $travel_day;
        $sqlr = "SELECT * FROM tdu_auto_assign_rules 
                WHERE assign_type = 'overAmount' AND CAST(region AS DECIMAL) < $total_amount
                AND (
                    ('$travel_month' > start_m OR ('$travel_month' = start_m AND '$travel_day' >= start_d))
                    AND
                    ('$travel_month' < end_m OR ('$travel_month' = end_m AND '$travel_day' <= end_d))
                )
                ORDER BY CAST(region AS DECIMAL) ASC;";
        $resultr = mysqli_query($conn, $sqlr);

        if ($resultr && mysqli_num_rows($resultr) > 0) {
            while ($rowr = mysqli_fetch_assoc($resultr)) {
                $category = $rowr['category'];
                if(!isset($assignment_map[$category])) {
                    continue;
                }
                $key = $assignment_map[$category];
                $value = $rowr['username'];

                $sql = "INSERT INTO vtiger_quotes_info (quoteid, quotetype, $key) 
                        VALUES ('$quoteid', 'group', '$value')
                        ON DUPLICATE KEY UPDATE $key = '$value'";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));
                echo "QuoteID: " . $quoteid . " - Total Amount: " . $total_amount . "<br>";
            }
        }
    }
}

mysqli_close($conn);
?>
