<?php
include "dbconn.php";

// Query to get quote numbers
$sql = "SELECT DISTINCT q.quote_no 
        FROM tdu_product_alt_vendors_in_quote a
        LEFT JOIN vtiger_quotes q ON a.quoteid = q.quoteid
        WHERE emailed = 0 AND actioned = 0";
$result = mysqli_query($conn, $sql);
if (!$result) {
    die("Query failed: " . mysqli_error($conn));
}

$emailid = "operations@turtledownunder.com.au";
$fromEmail = "abhisheks@turtledownunder.com.au";
$secondRecipientEmail = "maharshim@turtledownunder.com.au";
$secret = "tdu_cronjob";

// Check if there are any quotes
if (mysqli_num_rows($result) === 0) {
    echo "No quotes to process.\n";
    exit;
}

// Collect all quote numbers
$quote_list = [];
while ($row = mysqli_fetch_assoc($result)) {
    $quote_list[] = $row['quote_no'];
}

// Prepare email body using <br> for line breaks
$email_body = "<p>Please find the following quotes have vendors waiting approval:</p><br>";
$email_body .= implode("<br>", array_map(fn($q) => "$q", $quote_list));

// Format today's date
$date_today = date("d-M");
$subject = "Dashboard Vendor Pending Approval $date_today";

// Prepare email payload
$post_data = [
    'from' => $emailid,
    'to' => $fromEmail,
    'compose' => 'Yes',
    'subject' => $subject,
    'content' => $email_body,
    'secret' => $secret
];

// Send the email via cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://dashboard.turtledownunder.com.au/email_sender.php");
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Prepare second email payload
$second_post_data = [
    'from' => $emailid,
    'to' => $secondRecipientEmail,  // e.g., 'someoneelse@example.com'
    'compose' => 'Yes',
    'subject' => $subject,
    'content' => $email_body,
    'secret' => $secret
];

// Send the second email via cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://dashboard.turtledownunder.com.au/email_sender.php");
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($second_post_data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$second_response = curl_exec($ch);
$second_http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$update_sql = "UPDATE tdu_product_alt_vendors_in_quote SET emailed = 1";
mysqli_query($conn, $update_sql);

echo "Sent approval request for Quotes: " . implode(", ", $quote_list) . " | Response: $response | Status: $http_code\n";

mysqli_close($conn);
?>
